/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zhttp.http.Http;
import zhttp.http.Http$;
import zhttp.http.HttpData$;
import zhttp.http.HttpData$BinaryByteBuf$;
import zhttp.http.HttpData$BinaryChunk$;
import zhttp.http.HttpData$BinaryStream$;
import zhttp.http.HttpData$ByteBufConfig$;
import zhttp.http.HttpData$Empty$;
import zhttp.http.HttpData$FromAsciiString$;
import zhttp.http.HttpData$JavaFile$;
import zhttp.http.HttpData$UnsafeAsync$;
import zio.CanFail$;
import zio.Chunk;
import zio.FiberId$None$;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Trace$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface HttpData {
    public static HttpData empty() {
        return HttpData$.MODULE$.empty();
    }

    public static HttpData fromAsciiString(AsciiString asciiString) {
        return HttpData$.MODULE$.fromAsciiString(asciiString);
    }

    public static HttpData fromByteBuf(ByteBuf byteBuf) {
        return HttpData$.MODULE$.fromByteBuf(byteBuf);
    }

    public static HttpData fromCharSequence(CharSequence charSequence, Charset charset) {
        return HttpData$.MODULE$.fromCharSequence(charSequence, charset);
    }

    public static HttpData fromChunk(Chunk<Object> chunk) {
        return HttpData$.MODULE$.fromChunk(chunk);
    }

    public static HttpData fromFile(Function0<File> function0) {
        return HttpData$.MODULE$.fromFile(function0);
    }

    public static HttpData fromStream(ZStream<Object, Throwable, Object> zStream) {
        return HttpData$.MODULE$.fromStream(zStream);
    }

    public static HttpData fromStream(ZStream<Object, Throwable, CharSequence> zStream, Charset charset) {
        return HttpData$.MODULE$.fromStream(zStream, charset);
    }

    public static HttpData fromString(String string, Charset charset) {
        return HttpData$.MODULE$.fromString(string, charset);
    }

    public static int ordinal(HttpData httpData) {
        return HttpData$.MODULE$.ordinal(httpData);
    }

    public static Charset fromCharSequence$default$2() {
        return HttpData$.MODULE$.fromCharSequence$default$2();
    }

    public static Charset fromStream$default$2() {
        return HttpData$.MODULE$.fromStream$default$2();
    }

    public static Charset fromString$default$2() {
        return HttpData$.MODULE$.fromString$default$2();
    }

    public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig var1);

    public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig var1);

    public Http<Object, Throwable, Object, ByteBuf> toHttp(ByteBufConfig var1);

    public static boolean isEmpty$(HttpData $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        HttpData httpData = this;
        return HttpData$Empty$.MODULE$.equals(httpData);
    }

    public static ZIO toByteBuf$(HttpData $this) {
        return $this.toByteBuf();
    }

    default public ZIO<Object, Throwable, ByteBuf> toByteBuf() {
        return this.toByteBuf(HttpData$ByteBufConfig$.MODULE$.default());
    }

    public static ZStream toByteBufStream$(HttpData $this) {
        return $this.toByteBufStream();
    }

    default public ZStream<Object, Throwable, ByteBuf> toByteBufStream() {
        return this.toByteBufStream(HttpData$ByteBufConfig$.MODULE$.default());
    }

    public static Http toHttp$(HttpData $this) {
        return $this.toHttp();
    }

    default public Http<Object, Throwable, Object, ByteBuf> toHttp() {
        return this.toHttp(HttpData$ByteBufConfig$.MODULE$.default());
    }

    public static final class BinaryByteBuf
    implements HttpData,
    Complete,
    Product,
    Serializable {
        private final ByteBuf data;

        public static BinaryByteBuf apply(ByteBuf byteBuf) {
            return HttpData$BinaryByteBuf$.MODULE$.apply(byteBuf);
        }

        public static BinaryByteBuf fromProduct(Product product) {
            return HttpData$BinaryByteBuf$.MODULE$.fromProduct(product);
        }

        public static BinaryByteBuf unapply(BinaryByteBuf binaryByteBuf) {
            return HttpData$BinaryByteBuf$.MODULE$.unapply(binaryByteBuf);
        }

        public BinaryByteBuf(ByteBuf data) {
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BinaryByteBuf)) return false;
            BinaryByteBuf binaryByteBuf = (BinaryByteBuf)object;
            ByteBuf byteBuf = this.data();
            ByteBuf byteBuf2 = binaryByteBuf.data();
            if (byteBuf != null) {
                if (!byteBuf.equals(byteBuf2)) return false;
                return true;
            }
            if (byteBuf2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BinaryByteBuf;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BinaryByteBuf";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "data";
        }

        public ByteBuf data() {
            return this.data;
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$7 -> this.data(), (Object)"zhttp.http.HttpData$.BinaryByteBuf.toByteBuf.macro(HttpData.scala:236)");
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return ZStream$.MODULE$.fromZIO(() -> this.toByteBufStream$$anonfun$4(config), (Object)"zhttp.http.HttpData$.BinaryByteBuf.toByteBufStream.macro(HttpData.scala:242)");
        }

        public Http<Object, Nothing$, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.succeed(this.data());
        }

        public BinaryByteBuf copy(ByteBuf data) {
            return new BinaryByteBuf(data);
        }

        public ByteBuf copy$default$1() {
            return this.data();
        }

        public ByteBuf _1() {
            return this.data();
        }

        private final ZIO toByteBufStream$$anonfun$4(ByteBufConfig config$3) {
            return this.toByteBuf(config$3);
        }
    }

    public static final class BinaryChunk
    implements HttpData,
    Complete,
    Product,
    Serializable {
        private final Chunk data;

        public static BinaryChunk apply(Chunk<Object> chunk) {
            return HttpData$BinaryChunk$.MODULE$.apply(chunk);
        }

        public static BinaryChunk fromProduct(Product product) {
            return HttpData$BinaryChunk$.MODULE$.fromProduct(product);
        }

        public static BinaryChunk unapply(BinaryChunk binaryChunk) {
            return HttpData$BinaryChunk$.MODULE$.unapply(binaryChunk);
        }

        public BinaryChunk(Chunk<Object> data) {
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BinaryChunk)) return false;
            BinaryChunk binaryChunk = (BinaryChunk)object;
            Chunk<Object> chunk = this.data();
            Chunk<Object> chunk2 = binaryChunk.data();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BinaryChunk;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BinaryChunk";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "data";
        }

        public Chunk<Object> data() {
            return this.data;
        }

        private ByteBuf encode() {
            return Unpooled.wrappedBuffer((byte[])((byte[])this.data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> this.encode(), (Object)"zhttp.http.HttpData$.BinaryChunk.toByteBuf.macro(HttpData.scala:220)");
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return ZStream$.MODULE$.fromZIO(() -> this.toByteBufStream$$anonfun$3(config), (Object)"zhttp.http.HttpData$.BinaryChunk.toByteBufStream.macro(HttpData.scala:226)");
        }

        public Http<Object, Nothing$, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.succeed(this.encode());
        }

        public BinaryChunk copy(Chunk<Object> data) {
            return new BinaryChunk(data);
        }

        public Chunk<Object> copy$default$1() {
            return this.data();
        }

        public Chunk<Object> _1() {
            return this.data();
        }

        private final ZIO toByteBufStream$$anonfun$3(ByteBufConfig config$2) {
            return this.toByteBuf(config$2);
        }
    }

    public static final class BinaryStream
    implements HttpData,
    Complete,
    Product,
    Serializable {
        private final ZStream stream;

        public static BinaryStream apply(ZStream<Object, Throwable, ByteBuf> zStream) {
            return HttpData$BinaryStream$.MODULE$.apply(zStream);
        }

        public static BinaryStream fromProduct(Product product) {
            return HttpData$BinaryStream$.MODULE$.fromProduct(product);
        }

        public static BinaryStream unapply(BinaryStream binaryStream) {
            return HttpData$BinaryStream$.MODULE$.unapply(binaryStream);
        }

        public BinaryStream(ZStream<Object, Throwable, ByteBuf> stream) {
            this.stream = stream;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BinaryStream)) return false;
            BinaryStream binaryStream = (BinaryStream)object;
            ZStream<Object, Throwable, ByteBuf> zStream = this.stream();
            ZStream<Object, Throwable, ByteBuf> zStream2 = binaryStream.stream();
            if (zStream != null) {
                if (!zStream.equals(zStream2)) return false;
                return true;
            }
            if (zStream2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BinaryStream;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BinaryStream";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "stream";
        }

        public ZStream<Object, Throwable, ByteBuf> stream() {
            return this.stream;
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return HttpData$.MODULE$.zhttp$http$HttpData$$$collectStream(this.toByteBufStream(config));
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return this.stream();
        }

        @Override
        public Http<Object, Throwable, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.fromZIO(this.toByteBuf(config));
        }

        public BinaryStream copy(ZStream<Object, Throwable, ByteBuf> stream) {
            return new BinaryStream(stream);
        }

        public ZStream<Object, Throwable, ByteBuf> copy$default$1() {
            return this.stream();
        }

        public ZStream<Object, Throwable, ByteBuf> _1() {
            return this.stream();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ByteBufConfig
    implements Product,
    Serializable {
        private final int chunkSize;

        public static ByteBufConfig apply(int n) {
            return HttpData$ByteBufConfig$.MODULE$.apply(n);
        }

        public static ByteBufConfig default() {
            return HttpData$ByteBufConfig$.MODULE$.default();
        }

        public static ByteBufConfig fromProduct(Product product) {
            return HttpData$ByteBufConfig$.MODULE$.fromProduct(product);
        }

        public static ByteBufConfig unapply(ByteBufConfig byteBufConfig) {
            return HttpData$ByteBufConfig$.MODULE$.unapply(byteBufConfig);
        }

        public static int $lessinit$greater$default$1() {
            return HttpData$ByteBufConfig$.MODULE$.$lessinit$greater$default$1();
        }

        public ByteBufConfig(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.chunkSize());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ByteBufConfig)) return false;
            ByteBufConfig byteBufConfig = (ByteBufConfig)object;
            if (this.chunkSize() != byteBufConfig.chunkSize()) return false;
            if (!byteBufConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ByteBufConfig;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ByteBufConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "chunkSize";
        }

        public int chunkSize() {
            return this.chunkSize;
        }

        public int chunkSize(long fileLength) {
            int actualInt = (int)fileLength;
            return actualInt < 0 ? this.chunkSize() : (actualInt < this.chunkSize() ? actualInt : this.chunkSize());
        }

        public ByteBufConfig copy(int chunkSize) {
            return new ByteBufConfig(chunkSize);
        }

        public int copy$default$1() {
            return this.chunkSize();
        }

        public int _1() {
            return this.chunkSize();
        }
    }

    public static interface Complete
    extends HttpData {
    }

    public static class FromAsciiString
    implements HttpData,
    Complete,
    Product,
    Serializable {
        private final AsciiString asciiString;

        public static FromAsciiString apply(AsciiString asciiString) {
            return HttpData$FromAsciiString$.MODULE$.apply(asciiString);
        }

        public static FromAsciiString fromProduct(Product product) {
            return HttpData$FromAsciiString$.MODULE$.fromProduct(product);
        }

        public static FromAsciiString unapply(FromAsciiString fromAsciiString) {
            return HttpData$FromAsciiString$.MODULE$.unapply(fromAsciiString);
        }

        public FromAsciiString(AsciiString asciiString) {
            this.asciiString = asciiString;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FromAsciiString)) return false;
            FromAsciiString fromAsciiString = (FromAsciiString)object;
            AsciiString asciiString = this.asciiString();
            AsciiString asciiString2 = fromAsciiString.asciiString();
            if (asciiString == null) {
                if (asciiString2 != null) {
                    return false;
                }
            } else if (!asciiString.equals(asciiString2)) return false;
            if (!fromAsciiString.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FromAsciiString;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FromAsciiString";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "asciiString";
        }

        public AsciiString asciiString() {
            return this.asciiString;
        }

        private ByteBuf encode() {
            return Unpooled.wrappedBuffer((byte[])this.asciiString().array());
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$5 -> this.encode(), (Object)"zhttp.http.HttpData$.FromAsciiString.toByteBuf.macro(HttpData.scala:196)");
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return ZStream$.MODULE$.fromZIO(() -> this.toByteBufStream$$anonfun$2(config), (Object)"zhttp.http.HttpData$.FromAsciiString.toByteBufStream.macro(HttpData.scala:203)");
        }

        @Override
        public Http<Object, Throwable, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.attempt(this::toHttp$$anonfun$1);
        }

        public FromAsciiString copy(AsciiString asciiString) {
            return new FromAsciiString(asciiString);
        }

        public AsciiString copy$default$1() {
            return this.asciiString();
        }

        public AsciiString _1() {
            return this.asciiString();
        }

        private final ZIO toByteBufStream$$anonfun$2(ByteBufConfig config$1) {
            return this.toByteBuf(config$1);
        }

        private final ByteBuf toHttp$$anonfun$1() {
            return this.encode();
        }
    }

    public static final class JavaFile
    implements HttpData,
    Complete,
    Product,
    Serializable {
        private final Function0 unsafeFile;

        public static JavaFile apply(Function0<File> function0) {
            return HttpData$JavaFile$.MODULE$.apply(function0);
        }

        public static JavaFile fromProduct(Product product) {
            return HttpData$JavaFile$.MODULE$.fromProduct(product);
        }

        public static JavaFile unapply(JavaFile javaFile) {
            return HttpData$JavaFile$.MODULE$.unapply(javaFile);
        }

        public JavaFile(Function0<File> unsafeFile) {
            this.unsafeFile = unsafeFile;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof JavaFile)) return false;
            JavaFile javaFile = (JavaFile)object;
            Function0<File> function0 = this.unsafeFile();
            Function0<File> function02 = javaFile.unsafeFile();
            if (function0 != null) {
                if (!function0.equals(function02)) return false;
                return true;
            }
            if (function02 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof JavaFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "JavaFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "unsafeFile";
        }

        public Function0<File> unsafeFile() {
            return this.unsafeFile;
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return HttpData$.MODULE$.zhttp$http$HttpData$$$collectStream(this.toByteBufStream(config));
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return ZStream$.MODULE$.unwrap(() -> this.toByteBufStream$$anonfun$5(config), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:291)");
        }

        @Override
        public Http<Object, Throwable, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.fromZIO(this.toByteBuf(config));
        }

        public JavaFile copy(Function0<File> unsafeFile) {
            return new JavaFile(unsafeFile);
        }

        public Function0<File> copy$default$1() {
            return this.unsafeFile();
        }

        public Function0<File> _1() {
            return this.unsafeFile();
        }

        private final None$ toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3$$anonfun$2() {
            return None$.MODULE$;
        }

        private final /* synthetic */ ZIO toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3(byte[] buffer$5, int len) {
            return (len > 0 ? ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$11 -> Unpooled.copiedBuffer((byte[])buffer$5, (int)0, (int)len), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:287)") : ZIO$.MODULE$.fail(this::toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3$$anonfun$2, (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:287)")).map((Function1 & Serializable)bytes -> bytes, (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:288)");
        }

        private final ZIO toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1(FileInputStream fs$1, byte[] buffer$3) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$10 -> fs$1.read(buffer$3), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:286)").mapError((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:286)").flatMap((Function1 & Serializable)len -> this.toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3(buffer$3, BoxesRunTime.unboxToInt((Object)len)), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:288)");
        }

        private final ZIO toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$2(FileInputStream fs$3) {
            return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$12 -> fs$3.close(), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:290)");
        }

        private final ZIO toByteBufStream$$anonfun$5(ByteBufConfig config$4) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$8 -> (File)this.unsafeFile().apply(), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:279)").flatMap((Function1 & Serializable)file -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$9 -> new FileInputStream((File)file), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:280)").map((Function1 & Serializable)fs -> {
                int size = config$4.chunkSize(file.length());
                byte[] buffer = new byte[size];
                return Tuple3$.MODULE$.apply(fs, (Object)BoxesRunTime.boxToInteger((int)size), (Object)buffer);
            }, (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:282)").map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                FileInputStream fs = (FileInputStream)tuple3._1();
                int size = BoxesRunTime.unboxToInt((Object)tuple3._2());
                byte[] buffer = (byte[])tuple3._3();
                return ZStream$.MODULE$.repeatZIOOption(() -> this.toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$1(fs, buffer), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:289)").ensuring(() -> this.toByteBufStream$$anonfun$5$$anonfun$2$$anonfun$3$$anonfun$2(fs), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:290)");
            }, (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:290)"), (Object)"zhttp.http.HttpData$.JavaFile.toByteBufStream.macro(HttpData.scala:290)");
        }
    }

    public static final class UnsafeAsync
    implements HttpData,
    Product,
    Serializable {
        private final Function1 unsafeRun;

        public static UnsafeAsync apply(Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> function1) {
            return HttpData$UnsafeAsync$.MODULE$.apply(function1);
        }

        public static UnsafeAsync fromProduct(Product product) {
            return HttpData$UnsafeAsync$.MODULE$.fromProduct(product);
        }

        public static UnsafeAsync unapply(UnsafeAsync unsafeAsync) {
            return HttpData$UnsafeAsync$.MODULE$.unapply(unsafeAsync);
        }

        public UnsafeAsync(Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> unsafeRun) {
            this.unsafeRun = unsafeRun;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnsafeAsync)) return false;
            UnsafeAsync unsafeAsync = (UnsafeAsync)object;
            Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> function1 = this.unsafeRun();
            Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> function12 = unsafeAsync.unsafeRun();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnsafeAsync;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnsafeAsync";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "unsafeRun";
        }

        public Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> unsafeRun() {
            return this.unsafeRun;
        }

        private boolean isLast(HttpContent msg) {
            return msg instanceof LastHttpContent;
        }

        private ZIO<Object, Nothing$, Tuple2<ChannelHandlerContext, Queue<HttpContent>>> toQueue() {
            return Queue$.MODULE$.bounded(this::toQueue$$anonfun$1, (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:137)").flatMap((Function1 & Serializable)queue -> Promise$.MODULE$.make((Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:138)").flatMap((Function1 & Serializable)ctxPromise -> ZIO$.MODULE$.runtime((Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:139)").flatMap((Function1 & Serializable)runtime -> ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$1 -> this.unsafeRun().apply((Function1 & Serializable)ch -> (Function1)Unsafe$.MODULE$.unsafeCompat((Function1 & Serializable)u -> {
                runtime.unsafe().run(ctxPromise.succeed(ch, (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:144)"), Trace$.MODULE$.empty(), u);
                return (Function1 & Serializable)msg -> runtime.unsafe().run(queue.offer(msg, (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:145)"), Trace$.MODULE$.empty(), u);
            })), (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:148)").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return ctxPromise.await((Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:149)").map((Function1 & Serializable)ctx -> Tuple2$.MODULE$.apply(ctx, queue), (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:150)");
            }, (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:150)"), (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:150)"), (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:150)"), (Object)"zhttp.http.HttpData$.UnsafeAsync.toQueue.macro(HttpData.scala:150)");
        }

        @Override
        public ZIO<Object, Throwable, ByteBuf> toByteBuf(ByteBufConfig config) {
            return ZIO$.MODULE$.async((Function1 & Serializable)evidence$2 -> (Function1 & Serializable)cb -> this.unsafeRun().apply((Function1 & Serializable)ch -> {
                CompositeByteBuf buffer = Unpooled.compositeBuffer();
                return (Function1 & Serializable)msg -> {
                    Object object;
                    buffer.addComponent(true, msg.content());
                    if (this.isLast((HttpContent)msg)) {
                        object = cb.apply((Object)ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> buffer, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBuf.macro(HttpData.scala:162)"));
                    } else {
                        ch.read();
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                };
            }), this::toByteBuf$$anonfun$2, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBuf.macro(HttpData.scala:165)").map((Function1 & Serializable)body -> body, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBuf.macro(HttpData.scala:166)");
        }

        @Override
        public ZStream<Object, Throwable, ByteBuf> toByteBufStream(ByteBufConfig config) {
            return ZStream$.MODULE$.unwrap(this::toByteBufStream$$anonfun$1, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.macro(HttpData.scala:181)");
        }

        @Override
        public Http<Object, Throwable, Object, ByteBuf> toHttp(ByteBufConfig config) {
            return Http$.MODULE$.fromZIO(this.toByteBuf(config));
        }

        public UnsafeAsync copy(Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> unsafeRun) {
            return new UnsafeAsync(unsafeRun);
        }

        public Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> copy$default$1() {
            return this.unsafeRun();
        }

        public Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> _1() {
            return this.unsafeRun();
        }

        private final int toQueue$$anonfun$1() {
            return 1;
        }

        private final FiberId$None$ toByteBuf$$anonfun$2() {
            return ZIO$.MODULE$.async$default$2();
        }

        private final Queue $anonfun$1(Tuple2 reader$1) {
            return (Queue)reader$1._2();
        }

        private final int $anonfun$2() {
            return ZStream$.MODULE$.fromQueueWithShutdown$default$2();
        }

        private final ZIO toByteBufStream$$anonfun$1() {
            return this.toQueue().map((Function1 & Serializable)reader -> {
                ZStream stream = ZStream$.MODULE$.fromQueueWithShutdown(() -> this.$anonfun$1(reader), this::$anonfun$2, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.stream.macro(HttpData.scala:176)").tap((Function1 & Serializable)_$1 -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> ((ChannelHandlerContext)reader._1()).read(), (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.stream.macro(HttpData.scala:177)"), (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.stream.macro(HttpData.scala:177)").takeUntil((Function1 & Serializable)msg -> this.isLast((HttpContent)msg), (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.stream.macro(HttpData.scala:178)").map((Function1 & Serializable)_$2 -> _$2.content(), (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.stream.macro(HttpData.scala:179)");
                return Tuple2$.MODULE$.apply(reader, (Object)stream);
            }, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.macro(HttpData.scala:179)").map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 reader = (Tuple2)tuple2._1();
                ZStream stream = (ZStream)tuple2._2();
                return stream;
            }, (Object)"zhttp.http.HttpData$.UnsafeAsync.toByteBufStream.macro(HttpData.scala:180)");
        }
    }
}

