/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zhttp.http.Path;
import zhttp.http.Path$;
import zhttp.http.Path$Segment$;
import zhttp.http.Path$Segment$Root$;
import zhttp.http.Path$Segment$Text$;

public final class Path
implements Product,
Serializable {
    private final Vector segments;

    public static Path apply(Vector<Segment> vector) {
        return Path$.MODULE$.apply(vector);
    }

    public static Path decode(String string) {
        return Path$.MODULE$.decode(string);
    }

    public static Path empty() {
        return Path$.MODULE$.empty();
    }

    public static Path fromProduct(Product product) {
        return Path$.MODULE$.fromProduct(product);
    }

    public static Path root() {
        return Path$.MODULE$.root();
    }

    public static Path unapply(Path path) {
        return Path$.MODULE$.unapply(path);
    }

    public Path(Vector<Segment> segments) {
        this.segments = segments;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Path)) return false;
        Path path = (Path)object;
        Vector<Segment> vector = this.segments();
        Vector<Segment> vector2 = path.segments();
        if (vector != null) {
            if (!vector.equals(vector2)) return false;
            return true;
        }
        if (vector2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof Path;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Path";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "segments";
    }

    public Vector<Segment> segments() {
        return this.segments;
    }

    public Path $div(String name) {
        return Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().$colon$plus((Object)Path$Segment$.MODULE$.apply(name))));
    }

    public Path $div$colon(String name) {
        Segment segment = Path$Segment$.MODULE$.apply(name);
        return Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().$plus$colon((Object)segment)));
    }

    public Path $plus$plus(Path other) {
        return Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().$plus$plus(other.segments())));
    }

    public Path addTrailingSlash() {
        Option<Segment> option = this.lastSegment();
        return option instanceof Some && Path$Segment$Root$.MODULE$.equals(((Some)option).value()) ? this : this.$div("");
    }

    public Path concat(Path other) {
        return this.$plus$plus(other);
    }

    public Path drop(int n) {
        return Path$.MODULE$.apply((Vector<Segment>)this.segments().drop(n));
    }

    public Path dropLast(int n) {
        return Path$.MODULE$.apply((Vector<Segment>)this.segments().dropRight(n));
    }

    public Path dropTrailingSlash() {
        Option<Segment> option = this.lastSegment();
        return option instanceof Some && Path$Segment$Root$.MODULE$.equals(((Some)option).value()) ? this.dropLast(1) : this;
    }

    public String encode() {
        boolean addSlash;
        StringBuilder b = new StringBuilder();
        int len = this.segments().length();
        Option option = this.segments().headOption();
        boolean bl = addSlash = option instanceof Some && Path$Segment$Root$.MODULE$.equals(((Some)option).value());
        for (int i = 0; i < len; ++i) {
            Segment segment;
            Segment segment2 = (Segment)this.segments().apply(i);
            if (addSlash) {
                b.append('/');
                addSlash = false;
            }
            if (Path$Segment$Root$.MODULE$.equals(segment = segment2)) continue;
            if (segment instanceof Segment.Text) {
                String string;
                Segment.Text text = Path$Segment$Text$.MODULE$.unapply((Segment.Text)segment);
                String text2 = string = text._1();
                b.append(text2);
                addSlash = true;
                continue;
            }
            throw new MatchError((Object)segment);
        }
        return b.toString();
    }

    public Path initial() {
        return Path$.MODULE$.apply((Vector<Segment>)this.segments().init());
    }

    public boolean isEmpty() {
        return this.segments().isEmpty();
    }

    public boolean isRoot() {
        Segment segment;
        SeqOps seqOps;
        Vector<Segment> vector = this.segments();
        return vector != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector), 1) == 0 && Path$Segment$Root$.MODULE$.equals(segment = (Segment)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
    }

    public Option<String> last() {
        None$ none$;
        Segment segment;
        Option option = this.segments().lastOption();
        if (option instanceof Some && (segment = (Segment)((Some)option).value()) instanceof Segment.Text) {
            String string;
            Segment.Text text = Path$Segment$Text$.MODULE$.unapply((Segment.Text)segment);
            String text2 = string = text._1();
            none$ = Some$.MODULE$.apply((Object)text2);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Segment> lastSegment() {
        return this.segments().lastOption();
    }

    public boolean leadingSlash() {
        return this.segments().headOption().contains((Object)Path$Segment$.MODULE$.root());
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public Path reverse() {
        return Path$.MODULE$.apply((Vector<Segment>)((Vector)this.segments().reverse()));
    }

    public boolean startsWith(Path other) {
        return this.segments().startsWith(other.segments(), this.segments().startsWith$default$2());
    }

    public Path take(int n) {
        return Path$.MODULE$.apply((Vector<Segment>)this.segments().take(n));
    }

    public String toString() {
        return this.encode();
    }

    public boolean trailingSlash() {
        return this.segments().lastOption().contains((Object)Path$Segment$.MODULE$.root());
    }

    public Path copy(Vector<Segment> segments) {
        return new Path(segments);
    }

    public Vector<Segment> copy$default$1() {
        return this.segments();
    }

    public Vector<Segment> _1() {
        return this.segments();
    }

    public static interface Segment
    extends Product,
    Serializable {
        public static Segment apply(String string) {
            return Path$Segment$.MODULE$.apply(string);
        }

        public static int ordinal(Segment segment) {
            return Path$Segment$.MODULE$.ordinal(segment);
        }

        public static Segment root() {
            return Path$Segment$.MODULE$.root();
        }
    }
}

