/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http.headers;

import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import zhttp.http.Cookie;
import zhttp.http.Cookie$;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.MediaType;
import zhttp.http.MediaType$;
import zhttp.http.middleware.Auth;
import zhttp.http.middleware.Auth$Credentials$;
import zhttp.http.package$;
import zhttp.http.package$HeaderNames$;
import zhttp.service.server.ServerTime$;

public interface HeaderGetters<A> {
    public static Option accept$(HeaderGetters $this) {
        return $this.accept();
    }

    default public Option<CharSequence> accept() {
        return this.headerValue(package$HeaderNames$.MODULE$.accept());
    }

    public static Option acceptCharset$(HeaderGetters $this) {
        return $this.acceptCharset();
    }

    default public Option<CharSequence> acceptCharset() {
        return this.headerValue(package$HeaderNames$.MODULE$.acceptCharset());
    }

    public static Option acceptEncoding$(HeaderGetters $this) {
        return $this.acceptEncoding();
    }

    default public Option<CharSequence> acceptEncoding() {
        return this.headerValue(package$HeaderNames$.MODULE$.acceptEncoding());
    }

    public static Option acceptLanguage$(HeaderGetters $this) {
        return $this.acceptLanguage();
    }

    default public Option<CharSequence> acceptLanguage() {
        return this.headerValue(package$HeaderNames$.MODULE$.acceptLanguage());
    }

    public static Option acceptPatch$(HeaderGetters $this) {
        return $this.acceptPatch();
    }

    default public Option<CharSequence> acceptPatch() {
        return this.headerValue(package$HeaderNames$.MODULE$.acceptPatch());
    }

    public static Option acceptRanges$(HeaderGetters $this) {
        return $this.acceptRanges();
    }

    default public Option<CharSequence> acceptRanges() {
        return this.headerValue(package$HeaderNames$.MODULE$.acceptRanges());
    }

    public static Option accessControlAllowCredentials$(HeaderGetters $this) {
        return $this.accessControlAllowCredentials();
    }

    default public Option<Object> accessControlAllowCredentials() {
        None$ none$;
        Option<String> option = this.headerValue(package$HeaderNames$.MODULE$.accessControlAllowCredentials());
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            try {
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(string))));
            }
            catch (Throwable throwable) {
                none$ = None$.MODULE$;
            }
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public static Option accessControlAllowHeaders$(HeaderGetters $this) {
        return $this.accessControlAllowHeaders();
    }

    default public Option<CharSequence> accessControlAllowHeaders() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlAllowHeaders());
    }

    public static Option accessControlAllowMethods$(HeaderGetters $this) {
        return $this.accessControlAllowMethods();
    }

    default public Option<CharSequence> accessControlAllowMethods() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlAllowMethods());
    }

    public static Option accessControlAllowOrigin$(HeaderGetters $this) {
        return $this.accessControlAllowOrigin();
    }

    default public Option<CharSequence> accessControlAllowOrigin() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlAllowOrigin());
    }

    public static Option accessControlExposeHeaders$(HeaderGetters $this) {
        return $this.accessControlExposeHeaders();
    }

    default public Option<CharSequence> accessControlExposeHeaders() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlExposeHeaders());
    }

    public static Option accessControlMaxAge$(HeaderGetters $this) {
        return $this.accessControlMaxAge();
    }

    default public Option<CharSequence> accessControlMaxAge() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlMaxAge());
    }

    public static Option accessControlRequestHeaders$(HeaderGetters $this) {
        return $this.accessControlRequestHeaders();
    }

    default public Option<CharSequence> accessControlRequestHeaders() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlRequestHeaders());
    }

    public static Option accessControlRequestMethod$(HeaderGetters $this) {
        return $this.accessControlRequestMethod();
    }

    default public Option<CharSequence> accessControlRequestMethod() {
        return this.headerValue(package$HeaderNames$.MODULE$.accessControlRequestMethod());
    }

    public static Option age$(HeaderGetters $this) {
        return $this.age();
    }

    default public Option<CharSequence> age() {
        return this.headerValue(package$HeaderNames$.MODULE$.age());
    }

    public static Option allow$(HeaderGetters $this) {
        return $this.allow();
    }

    default public Option<CharSequence> allow() {
        return this.headerValue(package$HeaderNames$.MODULE$.allow());
    }

    public static Option authorization$(HeaderGetters $this) {
        return $this.authorization();
    }

    default public Option<CharSequence> authorization() {
        return this.headerValue(package$HeaderNames$.MODULE$.authorization());
    }

    public static Option basicAuthorizationCredentials$(HeaderGetters $this) {
        return $this.basicAuthorizationCredentials();
    }

    default public Option<Auth.Credentials> basicAuthorizationCredentials() {
        return this.authorization().map((Function1 & Serializable)_$1 -> _$1.toString()).flatMap((Function1 & Serializable)v -> {
            None$ none$;
            int indexOfBasic = v.indexOf(Headers$.MODULE$.BasicSchemeName());
            if (indexOfBasic != 0 || v.length() == Headers$.MODULE$.BasicSchemeName().length()) {
                none$ = None$.MODULE$;
            } else {
                try {
                    String encoded = v.substring(Headers$.MODULE$.BasicSchemeName().length() + 1);
                    none$ = this.decodeHttpBasic(encoded);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        none$ = None$.MODULE$;
                    }
                    throw throwable;
                }
            }
            return none$;
        });
    }

    public static Option bearerToken$(HeaderGetters $this) {
        return $this.bearerToken();
    }

    default public Option<String> bearerToken() {
        return this.authorization().map((Function1 & Serializable)_$2 -> _$2.toString()).flatMap((Function1 & Serializable)v -> {
            int indexOfBearer = v.indexOf(Headers$.MODULE$.BearerSchemeName());
            return indexOfBearer != 0 || v.length() == Headers$.MODULE$.BearerSchemeName().length() ? None$.MODULE$ : Some$.MODULE$.apply((Object)v.substring(Headers$.MODULE$.BearerSchemeName().length() + 1));
        });
    }

    public static Option cacheControl$(HeaderGetters $this) {
        return $this.cacheControl();
    }

    default public Option<CharSequence> cacheControl() {
        return this.headerValue(package$HeaderNames$.MODULE$.cacheControl());
    }

    public static Charset charset$(HeaderGetters $this) {
        return $this.charset();
    }

    default public Charset charset() {
        Charset charset;
        Option<String> option = this.headerValue(package$HeaderNames$.MODULE$.contentType());
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            charset = HttpUtil.getCharset((CharSequence)value, (Charset)package$.MODULE$.HTTP_CHARSET());
        } else if (None$.MODULE$.equals(option)) {
            charset = package$.MODULE$.HTTP_CHARSET();
        } else {
            throw new MatchError(option);
        }
        return charset;
    }

    public static Option connection$(HeaderGetters $this) {
        return $this.connection();
    }

    default public Option<CharSequence> connection() {
        return this.headerValue(package$HeaderNames$.MODULE$.connection());
    }

    public static Option contentBase$(HeaderGetters $this) {
        return $this.contentBase();
    }

    default public Option<CharSequence> contentBase() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentBase());
    }

    public static Option contentDisposition$(HeaderGetters $this) {
        return $this.contentDisposition();
    }

    default public Option<CharSequence> contentDisposition() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentDisposition());
    }

    public static Option contentEncoding$(HeaderGetters $this) {
        return $this.contentEncoding();
    }

    default public Option<CharSequence> contentEncoding() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentEncoding());
    }

    public static Option contentLanguage$(HeaderGetters $this) {
        return $this.contentLanguage();
    }

    default public Option<CharSequence> contentLanguage() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentLanguage());
    }

    public static Option contentLength$(HeaderGetters $this) {
        return $this.contentLength();
    }

    default public Option<Object> contentLength() {
        None$ none$;
        Option<String> option = this.headerValue(package$HeaderNames$.MODULE$.contentLength());
        if (option instanceof Some) {
            String str = (String)((Some)option).value();
            try {
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(str.toString()))));
            }
            catch (Throwable throwable) {
                none$ = None$.MODULE$;
            }
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public static Option contentLocation$(HeaderGetters $this) {
        return $this.contentLocation();
    }

    default public Option<CharSequence> contentLocation() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentLocation());
    }

    public static Option contentMd5$(HeaderGetters $this) {
        return $this.contentMd5();
    }

    default public Option<CharSequence> contentMd5() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentMd5());
    }

    public static Option contentRange$(HeaderGetters $this) {
        return $this.contentRange();
    }

    default public Option<CharSequence> contentRange() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentRange());
    }

    public static Option contentSecurityPolicy$(HeaderGetters $this) {
        return $this.contentSecurityPolicy();
    }

    default public Option<CharSequence> contentSecurityPolicy() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentSecurityPolicy());
    }

    public static Option contentTransferEncoding$(HeaderGetters $this) {
        return $this.contentTransferEncoding();
    }

    default public Option<CharSequence> contentTransferEncoding() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentTransferEncoding());
    }

    public static Option contentType$(HeaderGetters $this) {
        return $this.contentType();
    }

    default public Option<CharSequence> contentType() {
        return this.headerValue(package$HeaderNames$.MODULE$.contentType());
    }

    public static Option cookie$(HeaderGetters $this) {
        return $this.cookie();
    }

    default public Option<CharSequence> cookie() {
        return this.headerValue(package$HeaderNames$.MODULE$.cookie());
    }

    public static Option cookieValue$(HeaderGetters $this, CharSequence name) {
        return $this.cookieValue(name);
    }

    default public Option<CharSequence> cookieValue(CharSequence name) {
        return this.cookiesDecoded().find((Function1 & Serializable)_$3 -> {
            String string = _$3.name();
            CharSequence charSequence = name;
            return !(string != null ? !string.equals(charSequence) : charSequence != null);
        }).map((Function1 & Serializable)_$4 -> _$4.content());
    }

    public static List cookiesDecoded$(HeaderGetters $this) {
        return $this.cookiesDecoded();
    }

    default public List<Cookie> cookiesDecoded() {
        return this.headerValues(package$HeaderNames$.MODULE$.cookie()).flatMap((Function1 & Serializable)header -> Cookie$.MODULE$.decodeRequestCookie((String)header));
    }

    public static Option date$(HeaderGetters $this) {
        return $this.date();
    }

    default public Option<CharSequence> date() {
        return this.headerValue(package$HeaderNames$.MODULE$.date());
    }

    public static Option dnt$(HeaderGetters $this) {
        return $this.dnt();
    }

    default public Option<CharSequence> dnt() {
        return this.headerValue(package$HeaderNames$.MODULE$.dnt());
    }

    public static Option etag$(HeaderGetters $this) {
        return $this.etag();
    }

    default public Option<CharSequence> etag() {
        return this.headerValue(package$HeaderNames$.MODULE$.etag());
    }

    public static Option expect$(HeaderGetters $this) {
        return $this.expect();
    }

    default public Option<CharSequence> expect() {
        return this.headerValue(package$HeaderNames$.MODULE$.expect());
    }

    public static Option expires$(HeaderGetters $this) {
        return $this.expires();
    }

    default public Option<CharSequence> expires() {
        return this.headerValue(package$HeaderNames$.MODULE$.expires());
    }

    public static Option from$(HeaderGetters $this) {
        return $this.from();
    }

    default public Option<CharSequence> from() {
        return this.headerValue(package$HeaderNames$.MODULE$.from());
    }

    public static Option header$(HeaderGetters $this, CharSequence headerName) {
        return $this.header(headerName);
    }

    default public Option<Tuple2<CharSequence, CharSequence>> header(CharSequence headerName) {
        return this.headers().toList().find((Function1 & Serializable)h -> AsciiString.contentEqualsIgnoreCase((CharSequence)((CharSequence)h._1()), (CharSequence)headerName));
    }

    public static Option headerValue$(HeaderGetters $this, CharSequence headerName) {
        return $this.headerValue(headerName);
    }

    default public Option<String> headerValue(CharSequence headerName) {
        return this.header(headerName).map((Function1 & Serializable)_$5 -> ((CharSequence)_$5._2()).toString());
    }

    public static List headerValues$(HeaderGetters $this, CharSequence headerName) {
        return $this.headerValues(headerName);
    }

    default public List<String> headerValues(CharSequence headerName) {
        return this.headers().toList().collect((PartialFunction)new Serializable(headerName){
            private final CharSequence headerName$2;
            {
                this.headerName$2 = headerName$3;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                Tuple2 h = tuple2;
                return AsciiString.contentEqualsIgnoreCase((CharSequence)((CharSequence)h._1()), (CharSequence)this.headerName$2);
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                Tuple2 h = tuple2;
                return AsciiString.contentEqualsIgnoreCase((CharSequence)((CharSequence)h._1()), (CharSequence)this.headerName$2) ? ((String)h._2()).toString() : function1.apply((Object)x);
            }
        });
    }

    public Headers headers();

    public static List headersAsList$(HeaderGetters $this) {
        return $this.headersAsList();
    }

    default public List<Tuple2<String, String>> headersAsList() {
        return this.headers().toList();
    }

    public static Option host$(HeaderGetters $this) {
        return $this.host();
    }

    default public Option<CharSequence> host() {
        return this.headerValue(package$HeaderNames$.MODULE$.host());
    }

    public static Option ifMatch$(HeaderGetters $this) {
        return $this.ifMatch();
    }

    default public Option<CharSequence> ifMatch() {
        return this.headerValue(package$HeaderNames$.MODULE$.ifMatch());
    }

    public static Option ifModifiedSince$(HeaderGetters $this) {
        return $this.ifModifiedSince();
    }

    default public Option<CharSequence> ifModifiedSince() {
        return this.headerValue(package$HeaderNames$.MODULE$.ifModifiedSince());
    }

    public static Option ifModifiedSinceDecoded$(HeaderGetters $this) {
        return $this.ifModifiedSinceDecoded();
    }

    default public Option<Date> ifModifiedSinceDecoded() {
        return this.ifModifiedSince().map((Function1 & Serializable)date -> ServerTime$.MODULE$.parse(date.toString()));
    }

    public static Option ifNoneMatch$(HeaderGetters $this) {
        return $this.ifNoneMatch();
    }

    default public Option<CharSequence> ifNoneMatch() {
        return this.headerValue(package$HeaderNames$.MODULE$.ifNoneMatch());
    }

    public static Option ifRange$(HeaderGetters $this) {
        return $this.ifRange();
    }

    default public Option<CharSequence> ifRange() {
        return this.headerValue(package$HeaderNames$.MODULE$.ifRange());
    }

    public static Option ifUnmodifiedSince$(HeaderGetters $this) {
        return $this.ifUnmodifiedSince();
    }

    default public Option<CharSequence> ifUnmodifiedSince() {
        return this.headerValue(package$HeaderNames$.MODULE$.ifUnmodifiedSince());
    }

    public static Option lastModified$(HeaderGetters $this) {
        return $this.lastModified();
    }

    default public Option<CharSequence> lastModified() {
        return this.headerValue(package$HeaderNames$.MODULE$.lastModified());
    }

    public static Option location$(HeaderGetters $this) {
        return $this.location();
    }

    default public Option<CharSequence> location() {
        return this.headerValue(package$HeaderNames$.MODULE$.location());
    }

    public static Option maxForwards$(HeaderGetters $this) {
        return $this.maxForwards();
    }

    default public Option<CharSequence> maxForwards() {
        return this.headerValue(package$HeaderNames$.MODULE$.maxForwards());
    }

    public static Option mediaType$(HeaderGetters $this) {
        return $this.mediaType();
    }

    default public Option<MediaType> mediaType() {
        return this.contentType().flatMap((Function1 & Serializable)ct -> MediaType$.MODULE$.forContentType(ct.toString()));
    }

    public static Option origin$(HeaderGetters $this) {
        return $this.origin();
    }

    default public Option<CharSequence> origin() {
        return this.headerValue(package$HeaderNames$.MODULE$.origin());
    }

    public static Option pragma$(HeaderGetters $this) {
        return $this.pragma();
    }

    default public Option<CharSequence> pragma() {
        return this.headerValue(package$HeaderNames$.MODULE$.pragma());
    }

    public static Option proxyAuthenticate$(HeaderGetters $this) {
        return $this.proxyAuthenticate();
    }

    default public Option<CharSequence> proxyAuthenticate() {
        return this.headerValue(package$HeaderNames$.MODULE$.proxyAuthenticate());
    }

    public static Option proxyAuthorization$(HeaderGetters $this) {
        return $this.proxyAuthorization();
    }

    default public Option<CharSequence> proxyAuthorization() {
        return this.headerValue(package$HeaderNames$.MODULE$.proxyAuthorization());
    }

    public static Option range$(HeaderGetters $this) {
        return $this.range();
    }

    default public Option<CharSequence> range() {
        return this.headerValue(package$HeaderNames$.MODULE$.range());
    }

    public static Option referer$(HeaderGetters $this) {
        return $this.referer();
    }

    default public Option<CharSequence> referer() {
        return this.headerValue(package$HeaderNames$.MODULE$.referer());
    }

    public static Option retryAfter$(HeaderGetters $this) {
        return $this.retryAfter();
    }

    default public Option<CharSequence> retryAfter() {
        return this.headerValue(package$HeaderNames$.MODULE$.retryAfter());
    }

    public static Option secWebSocketAccept$(HeaderGetters $this) {
        return $this.secWebSocketAccept();
    }

    default public Option<CharSequence> secWebSocketAccept() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketAccept());
    }

    public static Option secWebSocketExtensions$(HeaderGetters $this) {
        return $this.secWebSocketExtensions();
    }

    default public Option<CharSequence> secWebSocketExtensions() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketExtensions());
    }

    public static Option secWebSocketKey$(HeaderGetters $this) {
        return $this.secWebSocketKey();
    }

    default public Option<CharSequence> secWebSocketKey() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketKey());
    }

    public static Option secWebSocketLocation$(HeaderGetters $this) {
        return $this.secWebSocketLocation();
    }

    default public Option<CharSequence> secWebSocketLocation() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketLocation());
    }

    public static Option secWebSocketOrigin$(HeaderGetters $this) {
        return $this.secWebSocketOrigin();
    }

    default public Option<CharSequence> secWebSocketOrigin() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketOrigin());
    }

    public static Option secWebSocketProtocol$(HeaderGetters $this) {
        return $this.secWebSocketProtocol();
    }

    default public Option<CharSequence> secWebSocketProtocol() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketProtocol());
    }

    public static Option secWebSocketVersion$(HeaderGetters $this) {
        return $this.secWebSocketVersion();
    }

    default public Option<CharSequence> secWebSocketVersion() {
        return this.headerValue(package$HeaderNames$.MODULE$.secWebSocketVersion());
    }

    public static Option server$(HeaderGetters $this) {
        return $this.server();
    }

    default public Option<CharSequence> server() {
        return this.headerValue(package$HeaderNames$.MODULE$.server());
    }

    public static Option setCookie$(HeaderGetters $this) {
        return $this.setCookie();
    }

    default public Option<CharSequence> setCookie() {
        return this.headerValue(package$HeaderNames$.MODULE$.setCookie());
    }

    public static List setCookiesDecoded$(HeaderGetters $this, Option secret) {
        return $this.setCookiesDecoded((Option<String>)secret);
    }

    default public List<Cookie> setCookiesDecoded(Option<String> secret) {
        return this.headerValues(package$HeaderNames$.MODULE$.setCookie()).map((Function1 & Serializable)_$6 -> Cookie$.MODULE$.decodeResponseCookie((String)_$6, secret)).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                boolean bl;
                Option option = x;
                if (option instanceof Some) {
                    Cookie cookie = (Cookie)((Some)option).value();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Object object;
                Option option = x;
                if (option instanceof Some) {
                    Cookie cookie = (Cookie)((Some)option).value();
                    object = cookie;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
    }

    public static Option setCookiesDecoded$default$1$(HeaderGetters $this) {
        return $this.setCookiesDecoded$default$1();
    }

    default public Option<String> setCookiesDecoded$default$1() {
        return None$.MODULE$;
    }

    public static Option te$(HeaderGetters $this) {
        return $this.te();
    }

    default public Option<CharSequence> te() {
        return this.headerValue(package$HeaderNames$.MODULE$.te());
    }

    public static Option trailer$(HeaderGetters $this) {
        return $this.trailer();
    }

    default public Option<CharSequence> trailer() {
        return this.headerValue(package$HeaderNames$.MODULE$.trailer());
    }

    public static Option transferEncoding$(HeaderGetters $this) {
        return $this.transferEncoding();
    }

    default public Option<CharSequence> transferEncoding() {
        return this.headerValue(package$HeaderNames$.MODULE$.transferEncoding());
    }

    public static Option upgrade$(HeaderGetters $this) {
        return $this.upgrade();
    }

    default public Option<CharSequence> upgrade() {
        return this.headerValue(package$HeaderNames$.MODULE$.upgrade());
    }

    public static Option upgradeInsecureRequests$(HeaderGetters $this) {
        return $this.upgradeInsecureRequests();
    }

    default public Option<CharSequence> upgradeInsecureRequests() {
        return this.headerValue(package$HeaderNames$.MODULE$.upgradeInsecureRequests());
    }

    public static Option userAgent$(HeaderGetters $this) {
        return $this.userAgent();
    }

    default public Option<CharSequence> userAgent() {
        return this.headerValue(package$HeaderNames$.MODULE$.userAgent());
    }

    public static Option vary$(HeaderGetters $this) {
        return $this.vary();
    }

    default public Option<CharSequence> vary() {
        return this.headerValue(package$HeaderNames$.MODULE$.vary());
    }

    public static Option via$(HeaderGetters $this) {
        return $this.via();
    }

    default public Option<CharSequence> via() {
        return this.headerValue(package$HeaderNames$.MODULE$.via());
    }

    public static Option warning$(HeaderGetters $this) {
        return $this.warning();
    }

    default public Option<CharSequence> warning() {
        return this.headerValue(package$HeaderNames$.MODULE$.warning());
    }

    public static Option webSocketLocation$(HeaderGetters $this) {
        return $this.webSocketLocation();
    }

    default public Option<CharSequence> webSocketLocation() {
        return this.headerValue(package$HeaderNames$.MODULE$.webSocketLocation());
    }

    public static Option webSocketOrigin$(HeaderGetters $this) {
        return $this.webSocketOrigin();
    }

    default public Option<CharSequence> webSocketOrigin() {
        return this.headerValue(package$HeaderNames$.MODULE$.webSocketOrigin());
    }

    public static Option webSocketProtocol$(HeaderGetters $this) {
        return $this.webSocketProtocol();
    }

    default public Option<CharSequence> webSocketProtocol() {
        return this.headerValue(package$HeaderNames$.MODULE$.webSocketProtocol());
    }

    public static Option wwwAuthenticate$(HeaderGetters $this) {
        return $this.wwwAuthenticate();
    }

    default public Option<CharSequence> wwwAuthenticate() {
        return this.headerValue(package$HeaderNames$.MODULE$.wwwAuthenticate());
    }

    public static Option xFrameOptions$(HeaderGetters $this) {
        return $this.xFrameOptions();
    }

    default public Option<CharSequence> xFrameOptions() {
        return this.headerValue(package$HeaderNames$.MODULE$.xFrameOptions());
    }

    public static Option xRequestedWith$(HeaderGetters $this) {
        return $this.xRequestedWith();
    }

    default public Option<CharSequence> xRequestedWith() {
        return this.headerValue(package$HeaderNames$.MODULE$.xRequestedWith());
    }

    private Option<Auth.Credentials> decodeHttpBasic(String encoded) {
        None$ none$;
        String decoded = new String(Base64.getDecoder().decode(encoded));
        int colonIndex = decoded.indexOf(":");
        if (colonIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            String username = decoded.substring(0, colonIndex);
            String password = colonIndex == decoded.length() - 1 ? "" : decoded.substring(colonIndex + 1);
            none$ = Some$.MODULE$.apply((Object)Auth$Credentials$.MODULE$.apply(username, password));
        }
        return none$;
    }
}

