/*
 * Decompiled with CFR 0.152.
 */
package zhttp.service;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.HttpData;
import zhttp.http.Method;
import zhttp.http.Method$GET$;
import zhttp.http.Proxy;
import zhttp.http.Request;
import zhttp.http.Request$;
import zhttp.http.Response;
import zhttp.http.URL;
import zhttp.http.Version$Http_1_1$;
import zhttp.http.package$HeaderNames$;
import zhttp.logging.Logger;
import zhttp.service.ChannelFuture$;
import zhttp.service.Client$;
import zhttp.service.Client$Config$;
import zhttp.service.HttpMessageCodec;
import zhttp.service.HttpRuntime;
import zhttp.service.WebSocketAppHandler;
import zhttp.service.client.ClientInboundHandler;
import zhttp.service.client.ClientSSLHandler;
import zhttp.service.client.ClientSSLHandler$;
import zhttp.service.client.ClientSSLHandler$ClientSSLOptions$DefaultSSL$;
import zhttp.service.package$;
import zhttp.socket.SocketApp;
import zhttp.socket.SocketApp$;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;

public final class Client<R>
implements HttpMessageCodec,
Product,
Serializable {
    private final HttpRuntime rtm;
    private final ChannelFactory cf;
    private final EventLoopGroup el;

    public static <R> Client<R> apply(HttpRuntime<R> httpRuntime, ChannelFactory<Channel> channelFactory, EventLoopGroup eventLoopGroup) {
        return Client$.MODULE$.apply(httpRuntime, channelFactory, eventLoopGroup);
    }

    public static Client<?> fromProduct(Product product) {
        return Client$.MODULE$.fromProduct(product);
    }

    public static Logger log() {
        return Client$.MODULE$.log();
    }

    public static <R> ZIO<R, Nothing$, Client<R>> make() {
        return Client$.MODULE$.make();
    }

    public static <R> Client<R> unapply(Client<R> client) {
        return Client$.MODULE$.unapply(client);
    }

    public static Method request$default$2() {
        return Client$.MODULE$.request$default$2();
    }

    public static Headers request$default$3() {
        return Client$.MODULE$.request$default$3();
    }

    public static <R> Headers socket$default$3() {
        return Client$.MODULE$.socket$default$3();
    }

    public static HttpData request$default$4() {
        return Client$.MODULE$.request$default$4();
    }

    public static ClientSSLHandler.ClientSSLOptions request$default$5() {
        return Client$.MODULE$.request$default$5();
    }

    public Client(HttpRuntime<R> rtm, ChannelFactory<Channel> cf, EventLoopGroup el) {
        this.rtm = rtm;
        this.cf = cf;
        this.el = el;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Client)) return false;
        Client client = (Client)object;
        HttpRuntime<R> httpRuntime = this.rtm();
        HttpRuntime<R> httpRuntime2 = client.rtm();
        if (httpRuntime == null) {
            if (httpRuntime2 != null) {
                return false;
            }
        } else if (!httpRuntime.equals(httpRuntime2)) return false;
        ChannelFactory<Channel> channelFactory = this.cf();
        ChannelFactory<Channel> channelFactory2 = client.cf();
        if (channelFactory == null) {
            if (channelFactory2 != null) {
                return false;
            }
        } else if (!channelFactory.equals(channelFactory2)) return false;
        EventLoopGroup eventLoopGroup = this.el();
        EventLoopGroup eventLoopGroup2 = client.el();
        if (eventLoopGroup == null) {
            if (eventLoopGroup2 == null) return true;
            return false;
        } else {
            if (!eventLoopGroup.equals(eventLoopGroup2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Client;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Client";
    }

    public Object productElement(int n) {
        EventLoopGroup eventLoopGroup;
        int n2 = n;
        switch (n2) {
            case 0: {
                eventLoopGroup = this._1();
                break;
            }
            case 1: {
                eventLoopGroup = this._2();
                break;
            }
            case 2: {
                eventLoopGroup = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return eventLoopGroup;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "rtm";
                break;
            }
            case 1: {
                string = "cf";
                break;
            }
            case 2: {
                string = "el";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public HttpRuntime<R> rtm() {
        return this.rtm;
    }

    public ChannelFactory<Channel> cf() {
        return this.cf;
    }

    public EventLoopGroup el() {
        return this.el;
    }

    public ZIO<Object, Throwable, Response> request(Request request, Config clientConfig) {
        return Promise$.MODULE$.make((Object)"zhttp.service.Client.request.macro(Client.scala:29)").flatMap((Function1 & Serializable)promise -> this.encode(request).flatMap((Function1 & Serializable)jReq -> ChannelFuture$.MODULE$.unit(() -> this.request$$anonfun$1$$anonfun$1$$anonfun$1(request, clientConfig, promise, jReq)).catchAll((Function1 & Serializable)cause -> promise.fail(cause, (Object)"zhttp.service.Client.request.macro(Client.scala:33)"), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zhttp.service.Client.request.macro(Client.scala:33)").flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            return promise.await((Object)"zhttp.service.Client.request.macro(Client.scala:34)").map((Function1 & Serializable)res -> res, (Object)"zhttp.service.Client.request.macro(Client.scala:35)");
        }, (Object)"zhttp.service.Client.request.macro(Client.scala:35)"), (Object)"zhttp.service.Client.request.macro(Client.scala:35)"), (Object)"zhttp.service.Client.request.macro(Client.scala:35)");
    }

    public ZIO<R, Throwable, Response> socket(URL url, Headers headers, SocketApp<R> socketApp, ClientSSLHandler.ClientSSLOptions sslOptions) {
        return ZIO$.MODULE$.environment((Object)"zhttp.service.Client.socket.macro(Client.scala:43)").flatMap((Function1 & Serializable)env -> this.request(Request$.MODULE$.apply(Version$Http_1_1$.MODULE$, Method$GET$.MODULE$, url, headers, Request$.MODULE$.apply$default$5()), Client$Config$.MODULE$.apply((Option<SocketApp<Object>>)Some$.MODULE$.apply(socketApp.provideEnvironment((ZEnvironment<R>)env)), (Option<ClientSSLHandler.ClientSSLOptions>)Some$.MODULE$.apply((Object)sslOptions), Client$Config$.MODULE$.$lessinit$greater$default$3())).withFinalizer((Function1 & Serializable)_$1 -> _$1.close().orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zhttp.service.Client.socket.macro(Client.scala:52)"), (Object)"zhttp.service.Client.socket.macro(Client.scala:52)").map((Function1 & Serializable)res -> res, (Object)"zhttp.service.Client.socket.macro(Client.scala:53)"), (Object)"zhttp.service.Client.socket.macro(Client.scala:53)");
    }

    public Headers socket$default$2() {
        return Headers$.MODULE$.empty();
    }

    public ClientSSLHandler.ClientSSLOptions socket$default$4() {
        return ClientSSLHandler$ClientSSLOptions$DefaultSSL$.MODULE$;
    }

    private ChannelFuture unsafeRequest(Request req, Config clientConfig, FullHttpRequest jReq, Promise<Throwable, Response> promise) {
        ChannelFuture channelFuture;
        try {
            String host;
            URI uri = new URI(jReq.uri());
            String string = host = uri.getHost() == null ? jReq.headers().get(package$HeaderNames$.MODULE$.host()) : uri.getHost();
            if (host == null) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"Host name is required");
            }
            int port = BoxesRunTime.unboxToInt((Object)req.url().port().getOrElse(Client::$anonfun$1));
            boolean isWebSocket = req.url().scheme().exists((Function1 & Serializable)_$2 -> _$2.isWebSocket());
            boolean isSSL = req.url().scheme().exists((Function1 & Serializable)_$3 -> _$3.isSecure());
            boolean isProxy = clientConfig.proxy().isDefined();
            ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(req, clientConfig, jReq, promise, host, port, isWebSocket, isSSL, isProxy, this){
                private final Request req$1;
                private final Config clientConfig$4;
                private final FullHttpRequest jReq$2;
                private final Promise promise$5;
                private final String host$1;
                private final int port$1;
                private final boolean isWebSocket$1;
                private final boolean isSSL$1;
                private final boolean isProxy$1;
                private final /* synthetic */ Client $outer;
                {
                    this.req$1 = req$2;
                    this.clientConfig$4 = clientConfig$6;
                    this.jReq$2 = jReq$3;
                    this.promise$5 = promise$6;
                    this.host$1 = host$2;
                    this.port$1 = port$2;
                    this.isWebSocket$1 = isWebSocket$2;
                    this.isSSL$1 = isSSL$2;
                    this.isProxy$1 = isProxy$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void initChannel(Channel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    ClientSSLHandler.ClientSSLOptions sslOption = (ClientSSLHandler.ClientSSLOptions)this.clientConfig$4.ssl().getOrElse(Client::zhttp$service$Client$$anon$1$$_$_$$anonfun$4);
                    if (this.isProxy$1) {
                        HttpProxyHandler handler = (HttpProxyHandler)this.clientConfig$4.proxy().flatMap(Client::zhttp$service$Client$$anon$1$$_$_$$anonfun$5).getOrElse(this::$anonfun$6);
                        pipeline.addLast(package$.MODULE$.PROXY_HANDLER(), (ChannelHandler)handler);
                    }
                    if (this.isSSL$1) {
                        pipeline.addLast(package$.MODULE$.SSL_HANDLER(), (ChannelHandler)ClientSSLHandler$.MODULE$.ssl(sslOption).newHandler(ch.alloc(), this.host$1, this.port$1));
                    }
                    pipeline.addLast(package$.MODULE$.HTTP_CLIENT_CODEC(), (ChannelHandler)new HttpClientCodec());
                    pipeline.addLast(package$.MODULE$.HTTP_OBJECT_AGGREGATOR(), (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                    pipeline.addLast(package$.MODULE$.CLIENT_INBOUND_HANDLER(), new ClientInboundHandler<R>(this.$outer.rtm(), this.jReq$2, (Promise<Throwable, Response>)this.promise$5, this.isWebSocket$1));
                    if (this.isWebSocket$1) {
                        HttpHeaders headers = this.req$1.headers().encode();
                        SocketApp app = (SocketApp)this.clientConfig$4.socketApp().getOrElse(Client::zhttp$service$Client$$anon$1$$_$_$$anonfun$7);
                        WebSocketClientProtocolConfig config = app.protocol().clientBuilder().customHeaders(headers).webSocketUri(this.req$1.url().encode()).build();
                        pipeline.addLast(package$.MODULE$.WEB_SOCKET_CLIENT_PROTOCOL_HANDLER(), (ChannelHandler)new WebSocketClientProtocolHandler(config));
                        pipeline.addLast(package$.MODULE$.WEB_SOCKET_HANDLER(), new WebSocketAppHandler<R>(this.$outer.rtm(), app, true));
                    }
                }

                private final HttpProxyHandler $anonfun$6() {
                    return new HttpProxyHandler((SocketAddress)new InetSocketAddress(this.host$1, this.port$1));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zhttp$service$Client$$anon$1$$_$_$$anonfun$4(), zhttp$service$Client$$anon$1$$_$_$$anonfun$5(zhttp.http.Proxy ), $anonfun$6(), zhttp$service$Client$$anon$1$$_$_$$anonfun$7()}, serializedLambda);
                }
            };
            Bootstrap jBoo = (Bootstrap)new Bootstrap().channelFactory(this.cf()).group(this.el()).handler((ChannelHandler)initializer);
            jBoo.remoteAddress((SocketAddress)new InetSocketAddress(host, port));
            channelFuture = jBoo.connect();
        }
        catch (Throwable err) {
            if (jReq.refCnt() > 0) {
                jReq.release(jReq.refCnt());
            }
            throw err;
        }
        return channelFuture;
    }

    public <R> Client<R> copy(HttpRuntime<R> rtm, ChannelFactory<Channel> cf, EventLoopGroup el) {
        return new Client<R>(rtm, cf, el);
    }

    public <R> HttpRuntime<R> copy$default$1() {
        return this.rtm();
    }

    public <R> ChannelFactory<Channel> copy$default$2() {
        return this.cf();
    }

    public <R> EventLoopGroup copy$default$3() {
        return this.el();
    }

    public HttpRuntime<R> _1() {
        return this.rtm();
    }

    public ChannelFactory<Channel> _2() {
        return this.cf();
    }

    public EventLoopGroup _3() {
        return this.el();
    }

    private final ChannelFuture request$$anonfun$1$$anonfun$1$$anonfun$1(Request request$3, Config clientConfig$3, Promise promise$2, FullHttpRequest jReq$1) {
        return this.unsafeRequest(request$3, clientConfig$3, jReq$1, (Promise<Throwable, Response>)promise$2);
    }

    private static final int $anonfun$1() {
        return 80;
    }

    public static final ClientSSLHandler$ClientSSLOptions$DefaultSSL$ zhttp$service$Client$$anon$1$$_$_$$anonfun$4() {
        return ClientSSLHandler$ClientSSLOptions$DefaultSSL$.MODULE$;
    }

    public static final /* synthetic */ Option zhttp$service$Client$$anon$1$$_$_$$anonfun$5(Proxy _$4) {
        return _$4.encode();
    }

    public static final SocketApp zhttp$service$Client$$anon$1$$_$_$$anonfun$7() {
        return SocketApp$.MODULE$.apply(SocketApp$.MODULE$.$lessinit$greater$default$1(), SocketApp$.MODULE$.$lessinit$greater$default$2(), SocketApp$.MODULE$.$lessinit$greater$default$3());
    }

    public static class Config
    implements Product,
    Serializable {
        private final Option socketApp;
        private final Option ssl;
        private final Option proxy;

        public static Config apply(Option<SocketApp<Object>> option, Option<ClientSSLHandler.ClientSSLOptions> option2, Option<Proxy> option3) {
            return Client$Config$.MODULE$.apply(option, option2, option3);
        }

        public static Config empty() {
            return Client$Config$.MODULE$.empty();
        }

        public static Config fromProduct(Product product) {
            return Client$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return Client$Config$.MODULE$.unapply(config);
        }

        public static Option<SocketApp<Object>> $lessinit$greater$default$1() {
            return Client$Config$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<ClientSSLHandler.ClientSSLOptions> $lessinit$greater$default$2() {
            return Client$Config$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Proxy> $lessinit$greater$default$3() {
            return Client$Config$.MODULE$.$lessinit$greater$default$3();
        }

        public Config(Option<SocketApp<Object>> socketApp, Option<ClientSSLHandler.ClientSSLOptions> ssl, Option<Proxy> proxy) {
            this.socketApp = socketApp;
            this.ssl = ssl;
            this.proxy = proxy;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            Option<SocketApp<Object>> option = this.socketApp();
            Option<SocketApp<Object>> option2 = config.socketApp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ClientSSLHandler.ClientSSLOptions> option3 = this.ssl();
            Option<ClientSSLHandler.ClientSSLOptions> option4 = config.ssl();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Proxy> option5 = this.proxy();
            Option<Proxy> option6 = config.proxy();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            if (!config.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "socketApp";
                    break;
                }
                case 1: {
                    string = "ssl";
                    break;
                }
                case 2: {
                    string = "proxy";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Option<SocketApp<Object>> socketApp() {
            return this.socketApp;
        }

        public Option<ClientSSLHandler.ClientSSLOptions> ssl() {
            return this.ssl;
        }

        public Option<Proxy> proxy() {
            return this.proxy;
        }

        public Config withSSL(ClientSSLHandler.ClientSSLOptions ssl) {
            Some some = Some$.MODULE$.apply((Object)ssl);
            Option<SocketApp<Object>> option = this.copy$default$1();
            Option<Proxy> option2 = this.copy$default$3();
            return this.copy(option, (Option<ClientSSLHandler.ClientSSLOptions>)some, option2);
        }

        public Config withSocketApp(SocketApp<Object> socketApp) {
            return this.copy((Option<SocketApp<Object>>)Some$.MODULE$.apply(socketApp), this.copy$default$2(), this.copy$default$3());
        }

        public Config withProxy(Proxy proxy) {
            Some some = Some$.MODULE$.apply((Object)proxy);
            Option<SocketApp<Object>> option = this.copy$default$1();
            Option<ClientSSLHandler.ClientSSLOptions> option2 = this.copy$default$2();
            return this.copy(option, option2, (Option<Proxy>)some);
        }

        public Config copy(Option<SocketApp<Object>> socketApp, Option<ClientSSLHandler.ClientSSLOptions> ssl, Option<Proxy> proxy) {
            return new Config(socketApp, ssl, proxy);
        }

        public Option<SocketApp<Object>> copy$default$1() {
            return this.socketApp();
        }

        public Option<ClientSSLHandler.ClientSSLOptions> copy$default$2() {
            return this.ssl();
        }

        public Option<Proxy> copy$default$3() {
            return this.proxy();
        }

        public Option<SocketApp<Object>> _1() {
            return this.socketApp();
        }

        public Option<ClientSSLHandler.ClientSSLOptions> _2() {
            return this.ssl();
        }

        public Option<Proxy> _3() {
            return this.proxy();
        }
    }
}

