/*
 * Decompiled with CFR 0.152.
 */
package zhttp.service;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import zhttp.http.HttpData;
import zhttp.http.HttpData$BinaryStream$;
import zhttp.http.HttpData$Empty$;
import zhttp.http.HttpData$JavaFile$;
import zhttp.http.HttpData$UnsafeAsync$;
import zhttp.http.HttpError;
import zhttp.http.HttpError$InternalServerError$;
import zhttp.http.HttpError$NotFound$;
import zhttp.http.Path$;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.http.Status;
import zhttp.http.package$HeaderValues$;
import zhttp.logging.Logger;
import zhttp.service.ChannelFuture$;
import zhttp.service.HttpRuntime;
import zhttp.service.Server;
import zhttp.service.ServerResponseWriter$;
import zhttp.service.server.ServerTime;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.ZStream;

public final class ServerResponseWriter<R> {
    private final HttpRuntime<R> runtime;
    private final Server.Config<R, Throwable> config;
    private final ServerTime serverTime;

    public static Logger log() {
        return ServerResponseWriter$.MODULE$.log();
    }

    public ServerResponseWriter(HttpRuntime<R> runtime, Server.Config<R, Throwable> config, ServerTime serverTime) {
        this.runtime = runtime;
        this.config = config;
        this.serverTime = serverTime;
    }

    private void attemptAutoRead(ChannelHandlerContext ctx) {
        if (!this.config.useAggregator() && !ctx.channel().config().isAutoRead()) {
            ctx.channel().config().setAutoRead(true);
            ctx.read();
        }
    }

    /*
     * Unable to fully structure code
     */
    private HttpResponse encodeResponse(Response res) {
        var3_2 = res.attribute().encoded();
        if (!(var3_2 instanceof Some) || (var4_3 = (Tuple2)((Some)var3_2).value()) == null) ** GOTO lbl-1000
        oRes = (Response)var4_3._1();
        jResponse = (HttpResponse)var4_3._2();
        if (oRes == res) {
            var7_6 = jResponse;
            if (var7_6 instanceof FullHttpResponse) {
                response = (FullHttpResponse)var7_6;
                v0 = response.retainedDuplicate();
            } else {
                v0 = response = var7_6;
            }
        } else lbl-1000:
        // 2 sources

        {
            v0 = jResponse = res.unsafeEncode();
        }
        if (res.attribute().serverTime()) {
            jResponse.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)this.serverTime.refreshAndGet());
        }
        return var2_9;
    }

    private void flushReleaseAndRead(HttpRequest jReq, ChannelHandlerContext ctx) {
        ctx.flush();
        this.releaseAndRead(jReq, ctx);
    }

    private void releaseAndRead(HttpRequest jReq, ChannelHandlerContext ctx) {
        this.releaseRequest(jReq, ctx);
        this.attemptAutoRead(ctx);
    }

    private void releaseRequest(HttpRequest jReq, ChannelHandlerContext ctx) {
        block0: {
            FullHttpRequest jReq2;
            HttpRequest httpRequest = jReq;
            if (!(httpRequest instanceof FullHttpRequest) || (jReq2 = (FullHttpRequest)httpRequest).refCnt() <= 0) break block0;
            jReq2.release(jReq2.refCnt());
        }
    }

    private void unsafeWriteFileContent(File file, ChannelHandlerContext ctx) {
        ctx.write((Object)new DefaultFileRegion(file, 0L, file.length()));
        ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    private void writeData(HttpData data, HttpRequest jReq, ChannelHandlerContext ctx) {
        HttpData httpData = data;
        if (httpData instanceof HttpData.FromAsciiString) {
            this.flushReleaseAndRead(jReq, ctx);
        } else if (httpData instanceof HttpData.BinaryChunk) {
            this.flushReleaseAndRead(jReq, ctx);
        } else if (httpData instanceof HttpData.BinaryByteBuf) {
            this.flushReleaseAndRead(jReq, ctx);
        } else if (HttpData$Empty$.MODULE$.equals(httpData)) {
            this.flushReleaseAndRead(jReq, ctx);
        } else if (httpData instanceof HttpData.BinaryStream) {
            ZStream<Object, Throwable, ByteBuf> zStream;
            HttpData.BinaryStream binaryStream = HttpData$BinaryStream$.MODULE$.unapply((HttpData.BinaryStream)httpData);
            ZStream<Object, Throwable, ByteBuf> stream = zStream = binaryStream._1();
            this.runtime.unsafeRun(ctx, this.writeStreamContent(stream, ctx).ensuring(() -> this.writeData$$anonfun$1(jReq, ctx), (Object)"zhttp.service.ServerResponseWriter.writeData.macro(ServerResponseWriter.scala:103)"), this.runtime.unsafeRun$default$3(ctx));
        } else if (httpData instanceof HttpData.JavaFile) {
            Function0<File> function0;
            HttpData.JavaFile javaFile = HttpData$JavaFile$.MODULE$.unapply((HttpData.JavaFile)httpData);
            Function0<File> unsafeGet = function0 = javaFile._1();
            this.unsafeWriteFileContent((File)unsafeGet.apply(), ctx);
            this.releaseAndRead(jReq, ctx);
        } else if (httpData instanceof HttpData.UnsafeAsync) {
            Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> function1;
            HttpData.UnsafeAsync unsafeAsync = HttpData$UnsafeAsync$.MODULE$.unapply((HttpData.UnsafeAsync)httpData);
            Function1<Function1<ChannelHandlerContext, Function1<HttpContent, Object>>, BoxedUnit> unsafeRun = function1 = unsafeAsync._1();
            unsafeRun.apply((Function1 & Serializable)_$1 -> (Function1 & Serializable)msg -> {
                BoxedUnit boxedUnit;
                ctx.writeAndFlush(msg);
                if (!(msg instanceof LastHttpContent)) {
                    ctx.read();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        } else {
            throw new MatchError((Object)httpData);
        }
    }

    private <A> ZIO<R, Throwable, BoxedUnit> writeStreamContent(ZStream<R, Throwable, ByteBuf> stream, ChannelHandlerContext ctx) {
        return stream.foreach((Function1 & Serializable)c -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> ctx.writeAndFlush(c), (Object)"zhttp.service.ServerResponseWriter.writeStreamContent.macro(ServerResponseWriter.scala:125)"), (Object)"zhttp.service.ServerResponseWriter.writeStreamContent.macro(ServerResponseWriter.scala:125)").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return ChannelFuture$.MODULE$.unit(() -> ServerResponseWriter.writeStreamContent$$anonfun$2$$anonfun$1(ctx)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
            }, (Object)"zhttp.service.ServerResponseWriter.writeStreamContent.macro(ServerResponseWriter.scala:127)");
        }, (Object)"zhttp.service.ServerResponseWriter.writeStreamContent.macro(ServerResponseWriter.scala:127)");
    }

    public void write(Throwable msg, HttpRequest jReq, ChannelHandlerContext ctx) {
        Some some = Some$.MODULE$.apply((Object)msg);
        String string = HttpError$InternalServerError$.MODULE$.$lessinit$greater$default$1();
        Response response = (Response)Response$.MODULE$.fromHttpError(HttpError$InternalServerError$.MODULE$.apply(string, (Option<Throwable>)some)).withConnection(package$HeaderValues$.MODULE$.close());
        this.write(response, jReq, ctx);
    }

    public void write(Response msg, HttpRequest jReq, ChannelHandlerContext ctx) {
        ctx.write((Object)this.encodeResponse(msg));
        this.writeData(msg.data(), jReq, ctx);
    }

    public void write(HttpError msg, HttpRequest jReq, ChannelHandlerContext ctx) {
        Response response = Response$.MODULE$.fromHttpError(msg);
        this.write(response, jReq, ctx);
    }

    public void write(Status msg, HttpRequest jReq, ChannelHandlerContext ctx) {
        Response response = Response$.MODULE$.status(msg);
        this.write(response, jReq, ctx);
    }

    public void writeNotFound(HttpRequest jReq, ChannelHandlerContext ctx) {
        HttpError.NotFound error = HttpError$NotFound$.MODULE$.apply(Path$.MODULE$.decode(jReq.uri()));
        this.write(error, jReq, ctx);
    }

    private final ZIO writeData$$anonfun$1(HttpRequest jReq$1, ChannelHandlerContext ctx$1) {
        return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$1 -> this.releaseAndRead(jReq$1, ctx$1), (Object)"zhttp.service.ServerResponseWriter.writeData.macro(ServerResponseWriter.scala:103)");
    }

    private static final ChannelFuture writeStreamContent$$anonfun$2$$anonfun$1(ChannelHandlerContext ctx$8) {
        return ctx$8.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }
}

