/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;
import zhttp.http.Cookie;
import zhttp.http.Cookie$SameSite$;
import zhttp.http.Cookie$SameSite$Lax$;
import zhttp.http.Cookie$SameSite$None$;
import zhttp.http.Cookie$SameSite$Strict$;
import zhttp.http.Path;
import zhttp.http.Path$;

public final class Cookie$
implements Mirror.Product,
Serializable {
    private static final String fieldExpires;
    private static final String fieldMaxAge;
    private static final String fieldDomain;
    private static final String fieldPath;
    private static final String fieldSecure;
    private static final String fieldHttpOnly;
    private static final String fieldSameSite;
    private static final String sameSiteLax;
    private static final String sameSiteStrict;
    private static final String sameSiteNone;
    private static final DateTimeFormatter dateTimeFormatter;
    public static final Cookie$SameSite$ SameSite;
    public static final Cookie$ MODULE$;

    private Cookie$() {
    }

    static {
        MODULE$ = new Cookie$();
        fieldExpires = "expires=";
        fieldMaxAge = "max-age=";
        fieldDomain = "domain=";
        fieldPath = "path=";
        fieldSecure = "secure";
        fieldHttpOnly = "httponly";
        fieldSameSite = "samesite=";
        sameSiteLax = "lax";
        sameSiteStrict = "strict";
        sameSiteNone = "none";
        dateTimeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss O ", Locale.ENGLISH).withZone(ZoneOffset.UTC);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cookie$.class);
    }

    public Cookie apply(String name, String content, Option<Instant> expires, Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Object> maxAge, Option<Cookie.SameSite> sameSite, Option<String> secret) {
        return new Cookie(name, content, expires, domain, path, isSecure, isHttpOnly, maxAge, sameSite, secret);
    }

    public Cookie unapply(Cookie x$1) {
        return x$1;
    }

    public String toString() {
        return "Cookie";
    }

    public Option<Instant> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<Path> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$6() {
        return false;
    }

    public boolean $lessinit$greater$default$7() {
        return false;
    }

    public Option<Object> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public Option<Cookie.SameSite> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$10() {
        return None$.MODULE$;
    }

    public DateTimeFormatter dateTimeFormatter() {
        return dateTimeFormatter;
    }

    public Option<Cookie> decodeResponseCookie(String headerValue, Option<String> secret) {
        return Try$.MODULE$.apply(() -> this.decodeResponseCookie$$anonfun$1(headerValue, secret)).toOption();
    }

    public Option<String> decodeResponseCookie$default$2() {
        return None$.MODULE$;
    }

    public Cookie unsafeDecodeResponseCookie(String headerValue, Option<String> secret) {
        Cookie cookie;
        String s;
        Cookie cookie2;
        String name = null;
        String content = null;
        Instant expires = null;
        None$ maxAge = None$.MODULE$;
        String domain = null;
        Path path = null;
        boolean secure = false;
        boolean httpOnly = false;
        Mirror.Singleton sameSite = null;
        int headerLength = headerValue.length();
        int curr = 0;
        int next = 0;
        while (next >= 0 && curr < headerLength) {
            next = headerValue.indexOf(59, curr);
            if (next < 0) {
                next = headerLength;
            }
            if (headerValue.charAt(curr) == ' ') {
                ++curr;
                continue;
            }
            if (name == null) {
                int splitIndex = headerValue.indexOf(61, curr);
                if (splitIndex >= 0 && splitIndex < next) {
                    name = headerValue.substring(0, splitIndex);
                    content = headerValue.substring(splitIndex + 1, next);
                } else {
                    name = headerValue.substring(0, next);
                }
            } else if (headerValue.regionMatches(true, curr, fieldExpires, 0, fieldExpires.length())) {
                expires = Instant.from(this.dateTimeFormatter().parse(headerValue.substring(curr + 8, next)));
            } else if (headerValue.regionMatches(true, curr, fieldMaxAge, 0, fieldMaxAge.length())) {
                maxAge = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(headerValue.substring(curr + 8, next)))));
            } else if (headerValue.regionMatches(true, curr, fieldDomain, 0, fieldDomain.length())) {
                domain = headerValue.substring(curr + 7, next);
            } else if (headerValue.regionMatches(true, curr, fieldPath, 0, fieldPath.length())) {
                String v = headerValue.substring(curr + 5, next);
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v))) {
                    path = Path$.MODULE$.decode(v);
                }
            } else if (headerValue.regionMatches(true, curr, fieldSecure, 0, fieldSecure.length())) {
                secure = true;
            } else if (headerValue.regionMatches(true, curr, fieldHttpOnly, 0, fieldHttpOnly.length())) {
                httpOnly = true;
            } else if (headerValue.regionMatches(true, curr, fieldSameSite, 0, fieldSameSite.length())) {
                if (headerValue.regionMatches(true, curr + 9, sameSiteLax, 0, sameSiteLax.length())) {
                    sameSite = Cookie$SameSite$Lax$.MODULE$;
                } else if (headerValue.regionMatches(true, curr + 9, sameSiteStrict, 0, sameSiteStrict.length())) {
                    sameSite = Cookie$SameSite$Strict$.MODULE$;
                } else if (headerValue.regionMatches(true, curr + 9, sameSiteNone, 0, sameSiteNone.length())) {
                    sameSite = Cookie$SameSite$None$.MODULE$;
                }
            }
            curr = next + 1;
        }
        if (name != null && !name.isEmpty() || content != null && !content.isEmpty()) {
            String string = name;
            String string2 = content;
            Option option = Option$.MODULE$.apply(expires);
            None$ none$ = maxAge;
            Option option2 = Option$.MODULE$.apply(domain);
            Option option3 = Option$.MODULE$.apply(path);
            boolean bl = secure;
            boolean bl2 = httpOnly;
            Option option4 = Option$.MODULE$.apply(sameSite);
            Option<String> option5 = this.$lessinit$greater$default$10();
            cookie2 = this.apply(string, string2, (Option<Instant>)option, (Option<String>)option2, (Option<Path>)option3, bl, bl2, (Option<Object>)none$, (Option<Cookie.SameSite>)option4, option5);
        } else {
            Option option = Option$.MODULE$.apply(expires);
            None$ none$ = maxAge;
            Option option6 = Option$.MODULE$.apply(domain);
            Option option7 = Option$.MODULE$.apply(path);
            boolean bl = secure;
            boolean bl3 = httpOnly;
            Option option8 = Option$.MODULE$.apply(sameSite);
            Option<String> option9 = this.$lessinit$greater$default$10();
            cookie2 = this.apply("", "", (Option<Instant>)option, (Option<String>)option6, (Option<Path>)option7, bl, bl3, (Option<Object>)none$, (Option<Cookie.SameSite>)option8, option9);
        }
        Cookie decodedCookie = cookie2;
        Option<String> option = secret;
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s = (String)((Some)option).value()))) {
            if (decodedCookie != null) {
                int index = decodedCookie.content().lastIndexOf(46);
                String signature = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(decodedCookie.content()), index + 1, decodedCookie.content().length());
                String content2 = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(decodedCookie.content()), 0, index);
                cookie = decodedCookie.zhttp$http$Cookie$$verify(content2, signature, s) ? decodedCookie.withContent(content2).sign(s) : null;
            } else {
                cookie = decodedCookie;
            }
        } else {
            cookie = decodedCookie.copy(decodedCookie.copy$default$1(), decodedCookie.copy$default$2(), decodedCookie.copy$default$3(), decodedCookie.copy$default$4(), decodedCookie.copy$default$5(), decodedCookie.copy$default$6(), decodedCookie.copy$default$7(), decodedCookie.copy$default$8(), decodedCookie.copy$default$9(), secret);
        }
        return cookie;
    }

    public Option<String> unsafeDecodeResponseCookie$default$2() {
        return None$.MODULE$;
    }

    public List<Cookie> decodeRequestCookie(String headerValue) {
        Object object;
        Object[] cookies;
        List x;
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(headerValue)) ? ((x = Predef$.MODULE$.wrapRefArray(cookies = (String[])ArrayOps$.MODULE$.map$extension(object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(headerValue), ';')), (Function1 & Serializable)_$3 -> _$3.trim(), ClassTag$.MODULE$.apply(String.class))).toList().map((Function1 & Serializable)a -> {
            Tuple2<String, String> tuple2 = this.splitNameContent((String)a);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            String content = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)content);
            String name2 = (String)tuple22._1();
            String content2 = (String)tuple22._2();
            return name2.isEmpty() && content2.isEmpty() ? Some$.MODULE$.apply((Object)this.apply("", "", this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.$lessinit$greater$default$10())) : Some$.MODULE$.apply((Object)this.apply(name2, content2, this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8(), this.$lessinit$greater$default$9(), this.$lessinit$greater$default$10()));
        })).contains((Object)None$.MODULE$) ? package$.MODULE$.List().empty() : x.map((Function1 & Serializable)_$4 -> (Cookie)_$4.get())) : package$.MODULE$.List().empty();
    }

    private Tuple2<String, String> splitNameContent(String str) {
        int i = str.indexOf(61);
        return i >= 0 ? Tuple2$.MODULE$.apply((Object)str.substring(0, i).trim(), (Object)str.substring(i + 1).trim()) : Tuple2$.MODULE$.apply((Object)str.trim(), (Object)"");
    }

    public Cookie fromProduct(Product x$0) {
        return new Cookie((String)x$0.productElement(0), (String)x$0.productElement(1), (Option<Instant>)((Option)x$0.productElement(2)), (Option<String>)((Option)x$0.productElement(3)), (Option<Path>)((Option)x$0.productElement(4)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(5)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(6)), (Option<Object>)((Option)x$0.productElement(7)), (Option<Cookie.SameSite>)((Option)x$0.productElement(8)), (Option<String>)((Option)x$0.productElement(9)));
    }

    private final Cookie decodeResponseCookie$$anonfun$1(String headerValue$1, Option secret$17) {
        return this.unsafeDecodeResponseCookie(headerValue$1, (Option<String>)secret$17);
    }
}

