/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.proxy.HttpProxyHandler;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import zhttp.http.Headers;
import zhttp.http.Proxy$;
import zhttp.http.URL;
import zhttp.http.middleware.Auth;

public final class Proxy
implements Product,
Serializable {
    private final URL url;
    private final Option credentials;
    private final Headers headers;

    public static Proxy apply(URL uRL, Option<Auth.Credentials> option, Headers headers) {
        return Proxy$.MODULE$.apply(uRL, option, headers);
    }

    public static Proxy empty() {
        return Proxy$.MODULE$.empty();
    }

    public static Proxy fromProduct(Product product) {
        return Proxy$.MODULE$.fromProduct(product);
    }

    public static Proxy unapply(Proxy proxy) {
        return Proxy$.MODULE$.unapply(proxy);
    }

    public static Option<Auth.Credentials> $lessinit$greater$default$2() {
        return Proxy$.MODULE$.$lessinit$greater$default$2();
    }

    public static Headers $lessinit$greater$default$3() {
        return Proxy$.MODULE$.$lessinit$greater$default$3();
    }

    public Proxy(URL url, Option<Auth.Credentials> credentials, Headers headers) {
        this.url = url;
        this.credentials = credentials;
        this.headers = headers;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Proxy)) return false;
        Proxy proxy = (Proxy)object;
        URL uRL = this.url();
        URL uRL2 = proxy.url();
        if (uRL == null) {
            if (uRL2 != null) {
                return false;
            }
        } else if (!((Object)uRL).equals(uRL2)) return false;
        Option<Auth.Credentials> option = this.credentials();
        Option<Auth.Credentials> option2 = proxy.credentials();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Headers headers = this.headers();
        Headers headers2 = proxy.headers();
        if (headers == null) {
            if (headers2 == null) return true;
            return false;
        } else {
            if (!((Object)headers).equals(headers2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Proxy;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Proxy";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "url";
                break;
            }
            case 1: {
                string = "credentials";
                break;
            }
            case 2: {
                string = "headers";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public URL url() {
        return this.url;
    }

    public Option<Auth.Credentials> credentials() {
        return this.credentials;
    }

    public Headers headers() {
        return this.headers;
    }

    public Proxy withUrl(URL url) {
        return this.copy(url, this.copy$default$2(), this.copy$default$3());
    }

    public Proxy withCredentials(Auth.Credentials credentials) {
        Some some = Some$.MODULE$.apply((Object)credentials);
        URL uRL = this.copy$default$1();
        Headers headers = this.copy$default$3();
        return this.copy(uRL, (Option<Auth.Credentials>)some, headers);
    }

    public Proxy withHeaders(Headers headers) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), headers);
    }

    public Option<HttpProxyHandler> encode() {
        return (Option)this.credentials().fold(this::encode$$anonfun$1, (Function1 & Serializable)credentials -> this.authorizedProxy((Auth.Credentials)credentials));
    }

    private Option<HttpProxyHandler> authorizedProxy(Auth.Credentials credentials) {
        return this.buildProxyAddress().map((Function1 & Serializable)proxyAddress -> {
            String uname = credentials.uname();
            String upassword = credentials.upassword();
            HttpHeaders encodedHeaders = this.headers().encode();
            return Tuple4$.MODULE$.apply(proxyAddress, (Object)uname, (Object)upassword, (Object)encodedHeaders);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)tuple4._1();
            String uname = (String)tuple4._2();
            String upassword = (String)tuple4._3();
            HttpHeaders encodedHeaders = (HttpHeaders)tuple4._4();
            return new HttpProxyHandler((SocketAddress)proxyAddress, uname, upassword, encodedHeaders);
        });
    }

    private Option<HttpProxyHandler> unauthorizedProxy() {
        return this.buildProxyAddress().map((Function1 & Serializable)proxyAddress -> {
            HttpHeaders encodedHeaders = this.headers().encode();
            return Tuple2$.MODULE$.apply(proxyAddress, (Object)encodedHeaders);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)tuple2._1();
            HttpHeaders encodedHeaders = (HttpHeaders)tuple2._2();
            return new HttpProxyHandler((SocketAddress)proxyAddress, encodedHeaders);
        });
    }

    private Option<InetSocketAddress> buildProxyAddress() {
        return this.url().host().flatMap((Function1 & Serializable)proxyHost -> this.url().port().map((Function1 & Serializable)proxyPort -> Proxy.buildProxyAddress$$anonfun$1$$anonfun$1(proxyHost, BoxesRunTime.unboxToInt((Object)proxyPort))));
    }

    public Proxy copy(URL url, Option<Auth.Credentials> credentials, Headers headers) {
        return new Proxy(url, credentials, headers);
    }

    public URL copy$default$1() {
        return this.url();
    }

    public Option<Auth.Credentials> copy$default$2() {
        return this.credentials();
    }

    public Headers copy$default$3() {
        return this.headers();
    }

    public URL _1() {
        return this.url();
    }

    public Option<Auth.Credentials> _2() {
        return this.credentials();
    }

    public Headers _3() {
        return this.headers();
    }

    private final Option encode$$anonfun$1() {
        return this.unauthorizedProxy();
    }

    private static final /* synthetic */ InetSocketAddress buildProxyAddress$$anonfun$1$$anonfun$1(String proxyHost$1, int proxyPort) {
        return new InetSocketAddress(proxyHost$1, proxyPort);
    }
}

