/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zhttp.html.Html;
import zhttp.http.Body;
import zhttp.http.Cookie;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.Http;
import zhttp.http.Http$;
import zhttp.http.HttpError;
import zhttp.http.Response$;
import zhttp.http.Response$Attribute$;
import zhttp.http.Status;
import zhttp.http.Status$SwitchingProtocols$;
import zhttp.http.headers.HeaderExtension;
import zhttp.service.ChannelEvent;
import zhttp.service.ChannelFuture$;
import zhttp.socket.SocketApp;
import zhttp.socket.WebSocketFrame;
import zio.ZIO;
import zio.ZIO$;

public final class Response
implements HeaderExtension<Response>,
Product,
Serializable {
    private final Status status;
    private final Headers headers;
    private final Body body;
    private final Attribute attribute;

    public static <R, E> Response apply(Status status, Headers headers, Body body) {
        return Response$.MODULE$.apply(status, headers, body);
    }

    public static Response apply(Status status, Headers headers, Body body, Attribute attribute) {
        return Response$.MODULE$.apply(status, headers, body, attribute);
    }

    public static Response fromHttpError(HttpError httpError) {
        return Response$.MODULE$.fromHttpError(httpError);
    }

    public static Response fromProduct(Product product) {
        return Response$.MODULE$.fromProduct(product);
    }

    public static <R> ZIO<R, Nothing$, Response> fromSocket(Http<R, Throwable, ChannelEvent<WebSocketFrame, WebSocketFrame>, BoxedUnit> http) {
        return Response$.MODULE$.fromSocket(http);
    }

    public static <R> ZIO<R, Nothing$, Response> fromSocketApp(SocketApp<R> socketApp) {
        return Response$.MODULE$.fromSocketApp(socketApp);
    }

    public static Response html(Html html, Status status) {
        return Response$.MODULE$.html(html, status);
    }

    public static Response json(CharSequence charSequence) {
        return Response$.MODULE$.json(charSequence);
    }

    public static Response ok() {
        return Response$.MODULE$.ok();
    }

    public static Response redirect(CharSequence charSequence, boolean bl) {
        return Response$.MODULE$.redirect(charSequence, bl);
    }

    public static Response seeOther(CharSequence charSequence) {
        return Response$.MODULE$.seeOther(charSequence);
    }

    public static Response text(CharSequence charSequence) {
        return Response$.MODULE$.text(charSequence);
    }

    public static Response unapply(Response response) {
        return Response$.MODULE$.unapply(response);
    }

    public static Response unsafeFromJResponse(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullHttpResponse) {
        return Response$.MODULE$.unsafeFromJResponse(channelHandlerContext, fullHttpResponse);
    }

    public static <R, E> Status apply$default$1() {
        return Response$.MODULE$.apply$default$1();
    }

    public static <R, E> Headers apply$default$2() {
        return Response$.MODULE$.apply$default$2();
    }

    public static Status html$default$2() {
        return Response$.MODULE$.html$default$2();
    }

    public static boolean redirect$default$2() {
        return Response$.MODULE$.redirect$default$2();
    }

    public static <R, E> Body apply$default$3() {
        return Response$.MODULE$.apply$default$3();
    }

    public Response(Status status, Headers headers, Body body, Attribute attribute) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.attribute = attribute;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Response)) return false;
        Response response = (Response)object;
        Status status = this.status();
        Status status2 = response.status();
        if (status == null) {
            if (status2 != null) {
                return false;
            }
        } else if (!status.equals(status2)) return false;
        Headers headers = this.headers();
        Headers headers2 = response.headers();
        if (headers == null) {
            if (headers2 != null) {
                return false;
            }
        } else if (!((Object)headers).equals(headers2)) return false;
        Body body = this.body();
        Body body2 = response.body();
        if (body == null) {
            if (body2 != null) {
                return false;
            }
        } else if (!body.equals(body2)) return false;
        Attribute attribute = this.attribute();
        Attribute attribute2 = response.attribute();
        if (attribute == null) {
            if (attribute2 == null) return true;
            return false;
        } else {
            if (!((Object)attribute).equals(attribute2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Response;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Response";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "status";
                break;
            }
            case 1: {
                string = "headers";
                break;
            }
            case 2: {
                string = "body";
                break;
            }
            case 3: {
                string = "attribute";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Status status() {
        return this.status;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public Body body() {
        return this.body;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public Response addCookie(Cookie cookie) {
        Headers headers = this.headers().$plus$plus(Headers$.MODULE$.apply(HttpHeaderNames.SET_COOKIE.toString(), cookie.encode()));
        Status status = this.copy$default$1();
        Body body = this.copy$default$3();
        Attribute attribute = this.copy$default$4();
        return this.copy(status, headers, body, attribute);
    }

    public ZIO<Object, Throwable, Response> freeze() {
        return this.encode().map((Function1 & Serializable)encoded -> {
            Attribute attribute = this.attribute().withEncodedResponse((HttpResponse)encoded, this);
            Status status = this.copy$default$1();
            Headers headers = this.copy$default$2();
            Body body = this.copy$default$3();
            return this.copy(status, headers, body, attribute);
        }, (Object)"zhttp.http.Response.freeze(Response.scala:39)");
    }

    public boolean isWebSocket() {
        return this.status().asJava().code() == Status$SwitchingProtocols$.MODULE$.asJava().code() && this.attribute().socketApp().nonEmpty();
    }

    public Response setAttribute(Attribute attribute) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), attribute);
    }

    public Response setStatus(Status status) {
        return this.copy(status, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Http<Object, Nothing$, Object, Response> toHttp() {
        return Http$.MODULE$.succeed(this);
    }

    @Override
    public Response updateHeaders(Function1<Headers, Headers> update) {
        Headers headers = (Headers)update.apply((Object)this.headers());
        Status status = this.copy$default$1();
        Body body = this.copy$default$3();
        Attribute attribute = this.copy$default$4();
        return this.copy(status, headers, body, attribute);
    }

    public Response withServerTime() {
        Attribute attribute = this.attribute().withServerTime();
        Status status = this.copy$default$1();
        Headers headers = this.copy$default$2();
        Body body = this.copy$default$3();
        return this.copy(status, headers, body, attribute);
    }

    public ZIO<Object, Throwable, BoxedUnit> close() {
        ZIO<Object, Throwable, BoxedUnit> zIO;
        Option<ChannelHandlerContext> option = this.attribute().channel();
        if (option instanceof Some) {
            ChannelHandlerContext channel = (ChannelHandlerContext)((Some)option).value();
            zIO = ChannelFuture$.MODULE$.unit(() -> Response.close$$anonfun$1(channel));
        } else if (None$.MODULE$.equals(option)) {
            zIO = ZIO$.MODULE$.fail(Response::close$$anonfun$2, (Object)"zhttp.http.Response.close(Response.scala:74)");
        } else {
            throw new MatchError(option);
        }
        return zIO;
    }

    public ZIO<Object, Throwable, HttpResponse> encode() {
        return (this.body().isComplete() ? this.body().asChunk().map((Function1 & Serializable)_$1 -> Some$.MODULE$.apply(_$1), (Object)"zhttp.http.Response.encode(Response.scala:84)") : ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> None$.MODULE$, (Object)"zhttp.http.Response.encode(Response.scala:84)")).flatMap((Function1 & Serializable)content -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$2 -> {
            DefaultHttpResponse defaultHttpResponse;
            HttpHeaders jHeaders = this.headers().encode();
            boolean hasContentLength = jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            Option option = content.map((Function1 & Serializable)chunks -> Unpooled.wrappedBuffer((byte[])((byte[])chunks.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)))));
            if (option instanceof Some) {
                ByteBuf jContent = (ByteBuf)((Some)option).value();
                DefaultFullHttpResponse jResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.status().asJava(), jContent, false);
                if (!hasContentLength) {
                    jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)jContent.readableBytes()));
                }
                jResponse.headers().add(jHeaders);
                defaultHttpResponse = jResponse;
            } else if (None$.MODULE$.equals(option)) {
                if (!hasContentLength) {
                    jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status().asJava(), jHeaders);
            } else {
                throw new MatchError((Object)option);
            }
            return defaultHttpResponse;
        }, (Object)"zhttp.http.Response.encode(Response.scala:105)").map((Function1 & Serializable)res -> res, (Object)"zhttp.http.Response.encode(Response.scala:106)"), (Object)"zhttp.http.Response.encode(Response.scala:106)");
    }

    public Response copy(Status status, Headers headers, Body body, Attribute attribute) {
        return new Response(status, headers, body, attribute);
    }

    public Status copy$default$1() {
        return this.status();
    }

    public Headers copy$default$2() {
        return this.headers();
    }

    public Body copy$default$3() {
        return this.body();
    }

    public Attribute copy$default$4() {
        return this.attribute();
    }

    public Status _1() {
        return this.status();
    }

    public Headers _2() {
        return this.headers();
    }

    public Body _3() {
        return this.body();
    }

    public Attribute _4() {
        return this.attribute();
    }

    private static final ChannelFuture close$$anonfun$1(ChannelHandlerContext channel$3) {
        return channel$3.close();
    }

    private static final IOException close$$anonfun$2() {
        return new IOException("Channel context isn't available");
    }

    public static final class Attribute
    implements Product,
    Serializable {
        private final Option socketApp;
        private final boolean memoize;
        private final boolean serverTime;
        private final Option encoded;
        private final Option channel;

        public static Attribute apply(Option<SocketApp<Object>> option, boolean bl, boolean bl2, Option<Tuple2<Response, HttpResponse>> option2, Option<ChannelHandlerContext> option3) {
            return Response$Attribute$.MODULE$.apply(option, bl, bl2, option2, option3);
        }

        public static Attribute empty() {
            return Response$Attribute$.MODULE$.empty();
        }

        public static Attribute fromProduct(Product product) {
            return Response$Attribute$.MODULE$.fromProduct(product);
        }

        public static Attribute unapply(Attribute attribute) {
            return Response$Attribute$.MODULE$.unapply(attribute);
        }

        public static Option<SocketApp<Object>> $lessinit$greater$default$1() {
            return Response$Attribute$.MODULE$.$lessinit$greater$default$1();
        }

        public static boolean $lessinit$greater$default$2() {
            return Response$Attribute$.MODULE$.$lessinit$greater$default$2();
        }

        public static boolean $lessinit$greater$default$3() {
            return Response$Attribute$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Tuple2<Response, HttpResponse>> $lessinit$greater$default$4() {
            return Response$Attribute$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<ChannelHandlerContext> $lessinit$greater$default$5() {
            return Response$Attribute$.MODULE$.$lessinit$greater$default$5();
        }

        public Attribute(Option<SocketApp<Object>> socketApp, boolean memoize, boolean serverTime, Option<Tuple2<Response, HttpResponse>> encoded, Option<ChannelHandlerContext> channel) {
            this.socketApp = socketApp;
            this.memoize = memoize;
            this.serverTime = serverTime;
            this.encoded = encoded;
            this.channel = channel;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.socketApp()));
            n = Statics.mix((int)n, (int)(this.memoize() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.serverTime() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.encoded()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.channel()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Attribute)) return false;
            Attribute attribute = (Attribute)object;
            if (this.memoize() != attribute.memoize()) return false;
            if (this.serverTime() != attribute.serverTime()) return false;
            Option<SocketApp<Object>> option = this.socketApp();
            Option<SocketApp<Object>> option2 = attribute.socketApp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Tuple2<Response, HttpResponse>> option3 = this.encoded();
            Option<Tuple2<Response, HttpResponse>> option4 = attribute.encoded();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<ChannelHandlerContext> option5 = this.channel();
            Option<ChannelHandlerContext> option6 = attribute.channel();
            if (option5 == null) {
                if (option6 == null) return true;
                return false;
            } else {
                if (!option5.equals(option6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Attribute;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Attribute";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "socketApp";
                    break;
                }
                case 1: {
                    string = "memoize";
                    break;
                }
                case 2: {
                    string = "serverTime";
                    break;
                }
                case 3: {
                    string = "encoded";
                    break;
                }
                case 4: {
                    string = "channel";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Option<SocketApp<Object>> socketApp() {
            return this.socketApp;
        }

        public boolean memoize() {
            return this.memoize;
        }

        public boolean serverTime() {
            return this.serverTime;
        }

        public Option<Tuple2<Response, HttpResponse>> encoded() {
            return this.encoded;
        }

        public Option<ChannelHandlerContext> channel() {
            return this.channel;
        }

        public Attribute withEncodedResponse(HttpResponse jResponse, Response response) {
            Response response2 = (Response)Predef$.MODULE$.ArrowAssoc((Object)response);
            Some some = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)response2, (Object)jResponse));
            Option<SocketApp<Object>> option = this.copy$default$1();
            boolean bl = this.copy$default$2();
            boolean bl2 = this.copy$default$3();
            Option<ChannelHandlerContext> option2 = this.copy$default$5();
            return this.copy(option, bl, bl2, (Option<Tuple2<Response, HttpResponse>>)some, option2);
        }

        public Attribute withMemoization() {
            return this.copy(this.copy$default$1(), true, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Attribute withServerTime() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), true, this.copy$default$4(), this.copy$default$5());
        }

        public Attribute withSocketApp(SocketApp<Object> app) {
            return this.copy((Option<SocketApp<Object>>)Option$.MODULE$.apply(app), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Attribute copy(Option<SocketApp<Object>> socketApp, boolean memoize, boolean serverTime, Option<Tuple2<Response, HttpResponse>> encoded, Option<ChannelHandlerContext> channel) {
            return new Attribute(socketApp, memoize, serverTime, encoded, channel);
        }

        public Option<SocketApp<Object>> copy$default$1() {
            return this.socketApp();
        }

        public boolean copy$default$2() {
            return this.memoize();
        }

        public boolean copy$default$3() {
            return this.serverTime();
        }

        public Option<Tuple2<Response, HttpResponse>> copy$default$4() {
            return this.encoded();
        }

        public Option<ChannelHandlerContext> copy$default$5() {
            return this.channel();
        }

        public Option<SocketApp<Object>> _1() {
            return this.socketApp();
        }

        public boolean _2() {
            return this.memoize();
        }

        public boolean _3() {
            return this.serverTime();
        }

        public Option<Tuple2<Response, HttpResponse>> _4() {
            return this.encoded();
        }

        public Option<ChannelHandlerContext> _5() {
            return this.channel();
        }
    }
}

