/*
 * Decompiled with CFR 0.152.
 */
package zhttp.http;

import java.io.Serializable;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zhttp.http.Path;
import zhttp.http.Path$;
import zhttp.http.Scheme;
import zhttp.http.Scheme$HTTP$;
import zhttp.http.URL;
import zhttp.http.URL$;
import zhttp.http.URL$Fragment$;
import zhttp.http.URL$Location$;
import zhttp.http.URL$Location$Absolute$;
import zhttp.http.URL$Location$Relative$;

public final class URL
implements Product,
Serializable {
    private final Path path;
    private final Location kind;
    private final Map queryParams;
    private final Option fragment;

    public static URL apply(Path path, Location location, Map<String, List<String>> map, Option<Fragment> option) {
        return URL$.MODULE$.apply(path, location, map, option);
    }

    public static URL empty() {
        return URL$.MODULE$.empty();
    }

    public static URL fromProduct(Product product) {
        return URL$.MODULE$.fromProduct(product);
    }

    public static Either<Exception, URL> fromString(String string) {
        return URL$.MODULE$.fromString(string);
    }

    public static URL root() {
        return URL$.MODULE$.root();
    }

    public static URL unapply(URL uRL) {
        return URL$.MODULE$.unapply(uRL);
    }

    public static Location $lessinit$greater$default$2() {
        return URL$.MODULE$.$lessinit$greater$default$2();
    }

    public static Map<String, List<String>> $lessinit$greater$default$3() {
        return URL$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Fragment> $lessinit$greater$default$4() {
        return URL$.MODULE$.$lessinit$greater$default$4();
    }

    public URL(Path path, Location kind, Map<String, List<String>> queryParams, Option<Fragment> fragment) {
        this.path = path;
        this.kind = kind;
        this.queryParams = queryParams;
        this.fragment = fragment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof URL)) return false;
        URL uRL = (URL)object;
        Path path = this.path();
        Path path2 = uRL.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Location location = this.kind();
        Location location2 = uRL.kind();
        if (location == null) {
            if (location2 != null) {
                return false;
            }
        } else if (!location.equals(location2)) return false;
        Map<String, List<String>> map = this.queryParams();
        Map<String, List<String>> map2 = uRL.queryParams();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<Fragment> option = this.fragment();
        Option<Fragment> option2 = uRL.fragment();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof URL;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "URL";
    }

    public Object productElement(int n) {
        Map<String, List<String>> map;
        int n2 = n;
        switch (n2) {
            case 0: {
                map = this._1();
                break;
            }
            case 1: {
                map = this._2();
                break;
            }
            case 2: {
                map = this._3();
                break;
            }
            case 3: {
                map = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return map;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "path";
                break;
            }
            case 1: {
                string = "kind";
                break;
            }
            case 2: {
                string = "queryParams";
                break;
            }
            case 3: {
                string = "fragment";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Path path() {
        return this.path;
    }

    public Location kind() {
        return this.kind;
    }

    public Map<String, List<String>> queryParams() {
        return this.queryParams;
    }

    public Option<Fragment> fragment() {
        return this.fragment;
    }

    public URL normalize() {
        Map queryParams = ((IterableOnceOps)this.queryParams().toList().filter((Function1 & Serializable)i -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)i._1())) && ((IterableOnceOps)i._2()).nonEmpty()).sortBy((Function1 & Serializable)_$1 -> (String)_$1._1(), (Ordering)Ordering.String$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Map<String, List<String>>)queryParams, this.copy$default$4());
    }

    public URL relative() {
        URL uRL;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            uRL = this;
        } else {
            URL$Location$Relative$ uRL$Location$Relative$ = URL$Location$Relative$.MODULE$;
            Path path = this.copy$default$1();
            Map<String, List<String>> map = this.copy$default$3();
            Option<Fragment> option = this.copy$default$4();
            uRL = this.copy(path, uRL$Location$Relative$, map, option);
        }
        return uRL;
    }

    public URL addTrailingSlash() {
        return this.copy(this.path().addTrailingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL dropTrailingSlash() {
        return this.copy(this.path().dropTrailingSlash(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public String encode() {
        return URL$.MODULE$.encode(this);
    }

    public Option<String> host() {
        None$ none$;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            none$ = None$.MODULE$;
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            none$ = Option$.MODULE$.apply((Object)abs.host());
        } else {
            throw new MatchError((Object)location);
        }
        return none$;
    }

    public boolean isAbsolute() {
        boolean bl;
        Location location = this.kind();
        if (location instanceof Location.Absolute) {
            Location.Absolute absolute = URL$Location$Absolute$.MODULE$.unapply((Location.Absolute)location);
            Scheme scheme = absolute._1();
            String string = absolute._2();
            int n = absolute._3();
            bl = true;
        } else if (URL$Location$Relative$.MODULE$.equals(location)) {
            bl = false;
        } else {
            throw new MatchError((Object)location);
        }
        return bl;
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public Option<Object> port() {
        None$ none$;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            none$ = None$.MODULE$;
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            none$ = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)abs.port()));
        } else {
            throw new MatchError((Object)location);
        }
        return none$;
    }

    public Option<Scheme> scheme() {
        None$ none$;
        Location location = this.kind();
        if (location instanceof Location.Absolute) {
            Location.Absolute absolute = URL$Location$Absolute$.MODULE$.unapply((Location.Absolute)location);
            Scheme scheme = absolute._1();
            String string = absolute._2();
            int n = absolute._3();
            Scheme scheme2 = scheme;
            none$ = Some$.MODULE$.apply((Object)scheme2);
        } else if (URL$Location$Relative$.MODULE$.equals(location)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)location);
        }
        return none$;
    }

    public URL setHost(String host) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(Scheme$HTTP$.MODULE$, host, URL$.MODULE$.zhttp$http$URL$$$portFromScheme(Scheme$HTTP$.MODULE$));
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            absolute = abs.copy(abs.copy$default$1(), host, abs.copy$default$3());
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public URL setPath(Path path) {
        return this.copy(path, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL setPath(String path) {
        return this.copy(Path$.MODULE$.decode(path), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public URL setPort(int port) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(Scheme$HTTP$.MODULE$, "", port);
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            absolute = abs.copy(abs.copy$default$1(), abs.copy$default$2(), port);
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public URL setQueryParams(Map<String, List<String>> queryParams) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), queryParams, this.copy$default$4());
    }

    public URL setQueryParams(String query) {
        Map<String, List<String>> map = URL$.MODULE$.zhttp$http$URL$$$queryParams(query);
        Path path = this.copy$default$1();
        Location location = this.copy$default$2();
        Option<Fragment> option = this.copy$default$4();
        return this.copy(path, location, map, option);
    }

    public URL setScheme(Scheme scheme) {
        Location.Absolute absolute;
        Location location = this.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            absolute = URL$Location$Absolute$.MODULE$.apply(scheme, "", URL$.MODULE$.zhttp$http$URL$$$portFromScheme(scheme));
        } else if (location instanceof Location.Absolute) {
            Location.Absolute abs = (Location.Absolute)location;
            absolute = abs.copy(scheme, abs.copy$default$2(), abs.copy$default$3());
        } else {
            throw new MatchError((Object)location);
        }
        Location.Absolute location2 = absolute;
        return this.copy(this.copy$default$1(), location2, this.copy$default$3(), this.copy$default$4());
    }

    public URI toJavaURI() {
        return new URI(this.encode());
    }

    public Option<java.net.URL> toJavaURL() {
        Location location = this.kind();
        URL$Location$Relative$ uRL$Location$Relative$ = URL$Location$Relative$.MODULE$;
        return !(location != null ? !location.equals(uRL$Location$Relative$) : uRL$Location$Relative$ != null) ? None$.MODULE$ : Some$.MODULE$.apply((Object)this.toJavaURI().toURL());
    }

    public URL copy(Path path, Location kind, Map<String, List<String>> queryParams, Option<Fragment> fragment) {
        return new URL(path, kind, queryParams, fragment);
    }

    public Path copy$default$1() {
        return this.path();
    }

    public Location copy$default$2() {
        return this.kind();
    }

    public Map<String, List<String>> copy$default$3() {
        return this.queryParams();
    }

    public Option<Fragment> copy$default$4() {
        return this.fragment();
    }

    public Path _1() {
        return this.path();
    }

    public Location _2() {
        return this.kind();
    }

    public Map<String, List<String>> _3() {
        return this.queryParams();
    }

    public Option<Fragment> _4() {
        return this.fragment();
    }

    public static class Fragment
    implements Product,
    Serializable {
        private final String raw;
        private final String decoded;

        public static Fragment apply(String string, String string2) {
            return URL$Fragment$.MODULE$.apply(string, string2);
        }

        public static Fragment fromProduct(Product product) {
            return URL$Fragment$.MODULE$.fromProduct(product);
        }

        public static Option<Fragment> fromURI(URI uRI) {
            return URL$Fragment$.MODULE$.fromURI(uRI);
        }

        public static Fragment unapply(Fragment fragment) {
            return URL$Fragment$.MODULE$.unapply(fragment);
        }

        public Fragment(String raw, String decoded) {
            this.raw = raw;
            this.decoded = decoded;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Fragment)) return false;
            Fragment fragment = (Fragment)object;
            String string = this.raw();
            String string2 = fragment.raw();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.decoded();
            String string4 = fragment.decoded();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!fragment.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Fragment;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Fragment";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = this._1();
            } else if (1 == n2) {
                string = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "raw";
            } else if (1 == n2) {
                string = "decoded";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String raw() {
            return this.raw;
        }

        public String decoded() {
            return this.decoded;
        }

        public Fragment copy(String raw, String decoded) {
            return new Fragment(raw, decoded);
        }

        public String copy$default$1() {
            return this.raw();
        }

        public String copy$default$2() {
            return this.decoded();
        }

        public String _1() {
            return this.raw();
        }

        public String _2() {
            return this.decoded();
        }
    }

    public static interface Location {
        public static int ordinal(Location location) {
            return URL$Location$.MODULE$.ordinal(location);
        }
    }
}

