/*
 * Decompiled with CFR 0.152.
 */
package zhttp.service.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import zhttp.http.Response;
import zhttp.http.Response$;
import zhttp.service.HttpRuntime;
import zio.Promise;

public final class ClientInboundHandler<R>
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private final HttpRuntime<R> zExec;
    private final FullHttpRequest jReq;
    private final Promise<Throwable, Response> promise;
    private final boolean isWebSocket;

    public ClientInboundHandler(HttpRuntime<R> zExec, FullHttpRequest jReq, Promise<Throwable, Response> promise, boolean isWebSocket) {
        this.zExec = zExec;
        this.jReq = jReq;
        this.promise = promise;
        this.isWebSocket = isWebSocket;
        super(true);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.isWebSocket) {
            ctx.fireChannelActive();
        } else {
            ctx.writeAndFlush((Object)this.jReq);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
        msg.touch((Object)"handlers.ClientInboundHandler-channelRead0");
        this.zExec.unsafeRunUninterruptible(this.promise.succeed((Object)Response$.MODULE$.unsafeFromJResponse(ctx, msg), (Object)"zhttp.service.client.ClientInboundHandler.channelRead0(ClientInboundHandler.scala:32)"), ctx);
        if (this.isWebSocket) {
            ctx.fireChannelRead((Object)msg.retain());
            ctx.pipeline().remove(ctx.name());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        this.zExec.unsafeRunUninterruptible(this.promise.fail((Object)error, (Object)"zhttp.service.client.ClientInboundHandler.exceptionCaught(ClientInboundHandler.scala:41)"), ctx);
        this.releaseRequest();
    }

    private void releaseRequest() {
        if (this.jReq.refCnt() > 0) {
            this.jReq.release(this.jReq.refCnt());
        }
    }
}

