package io.dangernoodle;

/**
 * Simple value object for holding authentication credentials
 *
 * @since 0.1.0
 */
public class Credentials
{
    /** static object representing empty credentials */
    public static final Credentials EMPTY = new Credentials("", "");

    private final String password;
    private final String username;

    public Credentials(String username, String password)
    {
        this.username = username;
        this.password = password;
    }

    public String getPassword()
    {
        return password;
    }

    public String getUsername()
    {
        return username;
    }
}
