package io.dangernoodle;

import io.dangernoodle.scm.setup.RepositorySettings;


/**
 * Simple value object that describes a project
 *
 * @since 0.1.0
 */
public class Project
{
    private String name;

    private RepositorySettings scm;

    public String getName()
    {
        return name;
    }

    @SuppressWarnings("unchecked")
    public <T extends RepositorySettings> T getRepositorySettings()
    {
        return (T) scm;
    }

    public void overrideSettings(RepositorySettings settings)
    {
        this.scm = settings;
    }
}
