package io.dangernoodle.utils;

import java.io.Reader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;


public abstract class GsonTransformer implements JsonTransformer
{
    private final Gson gson;

    private final JsonParser jsonParser;

    private final Gson prettyPrinter;

    public GsonTransformer()
    {
        GsonBuilder builder = createGsonBuilder();

        this.gson = builder.create();
        this.jsonParser = new JsonParser();
        this.prettyPrinter = builder.setPrettyPrinting().create();
    }

    @Override
    public <T> T deserialize(Reader reader, Class<T> clazz)
    {
        return gson.fromJson(reader, clazz);
    }

    @Override
    public <T> T deserialize(String json, Class<T> clazz)
    {
        return gson.fromJson(json, clazz);
    }

    @Override
    public String prettyPrint(String json)
    {
        return prettyPrinter.toJson(jsonParser.parse(json).getAsJsonObject());
    }

    protected abstract GsonBuilder createGsonBuilder();
}
