/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import io.dapr.actors.ActorId;
import io.dapr.actors.ActorMethod;
import io.dapr.actors.client.ActorClient;
import io.dapr.actors.client.ActorProxy;
import io.dapr.exceptions.DaprException;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import reactor.core.publisher.Mono;

class ActorProxyImpl
implements ActorProxy,
InvocationHandler {
    private static final String UNDEFINED_CLASS_NAME = "io.dapr.actors.Undefined";
    private final ActorId actorId;
    private final String actorType;
    private final DaprObjectSerializer serializer;
    private final ActorClient actorClient;

    ActorProxyImpl(String actorType, ActorId actorId, DaprObjectSerializer serializer, ActorClient actorClient) {
        this.actorType = actorType;
        this.actorId = actorId;
        this.actorClient = actorClient;
        this.serializer = serializer;
    }

    @Override
    public ActorId getActorId() {
        return this.actorId;
    }

    @Override
    public String getActorType() {
        return this.actorType;
    }

    @Override
    public <T> Mono<T> invokeMethod(String methodName, Object data, TypeRef<T> type) {
        return this.actorClient.invoke(this.actorType, this.actorId.toString(), methodName, this.serialize(data)).filter(s -> ((byte[])s).length > 0).map(s -> this.deserialize((byte[])s, type));
    }

    @Override
    public <T> Mono<T> invokeMethod(String methodName, Object data, Class<T> clazz) {
        return this.invokeMethod(methodName, data, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeMethod(String methodName, TypeRef<T> type) {
        return this.actorClient.invoke(this.actorType, this.actorId.toString(), methodName, null).filter(s -> ((byte[])s).length > 0).map(s -> this.deserialize((byte[])s, type));
    }

    @Override
    public <T> Mono<T> invokeMethod(String methodName, Class<T> clazz) {
        return this.invokeMethod(methodName, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> invokeMethod(String methodName) {
        return this.actorClient.invoke(this.actorType, this.actorId.toString(), methodName, null).then();
    }

    @Override
    public Mono<Void> invokeMethod(String methodName, Object data) {
        return this.actorClient.invoke(this.actorType, this.actorId.toString(), methodName, this.serialize(data)).then();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getParameterCount() > 1) {
            throw new UnsupportedOperationException("Actor methods can only have zero or one arguments.");
        }
        ActorMethod actorMethodAnnotation = method.getDeclaredAnnotation(ActorMethod.class);
        String methodName = method.getName();
        if (actorMethodAnnotation != null && !actorMethodAnnotation.name().isEmpty()) {
            methodName = actorMethodAnnotation.name();
        }
        if (method.getParameterCount() == 0) {
            if (method.getReturnType().equals(Mono.class)) {
                if (actorMethodAnnotation == null || UNDEFINED_CLASS_NAME.equals(actorMethodAnnotation.returns().getName())) {
                    return this.invokeMethod(methodName);
                }
                return this.invokeMethod(methodName, actorMethodAnnotation.returns());
            }
            return this.invokeMethod(methodName, method.getReturnType()).block();
        }
        if (method.getReturnType().equals(Mono.class)) {
            if (actorMethodAnnotation == null || UNDEFINED_CLASS_NAME.equals(actorMethodAnnotation.returns().getName())) {
                return this.invokeMethod(methodName, args[0]);
            }
            return this.invokeMethod(methodName, args[0], actorMethodAnnotation.returns());
        }
        return this.invokeMethod(methodName, args[0], method.getReturnType()).block();
    }

    private <T> T deserialize(byte[] response, TypeRef<T> type) {
        try {
            return (T)this.serializer.deserialize(response, type);
        }
        catch (IOException e) {
            DaprException.wrap((Throwable)e);
            return null;
        }
    }

    private byte[] serialize(Object request) {
        try {
            return this.serializer.serialize(request);
        }
        catch (IOException e) {
            DaprException.wrap((Throwable)e);
            return null;
        }
    }
}

