/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import com.google.protobuf.ByteString;
import io.dapr.actors.client.DaprClient;
import io.dapr.client.resiliency.ResiliencyOptions;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.dapr.internal.opencensus.GrpcWrapper;
import io.dapr.internal.resiliency.RetryPolicy;
import io.dapr.internal.resiliency.TimeoutPolicy;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.util.context.ContextView;

class DaprGrpcClient
implements DaprClient {
    private final TimeoutPolicy timeoutPolicy;
    private final RetryPolicy retryPolicy;
    private final DaprGrpc.DaprStub client;

    DaprGrpcClient(DaprGrpc.DaprStub grpcClient, ResiliencyOptions resiliencyOptions) {
        this.client = this.intercept(grpcClient);
        this.timeoutPolicy = new TimeoutPolicy(resiliencyOptions == null ? null : resiliencyOptions.getTimeout());
        this.retryPolicy = new RetryPolicy(resiliencyOptions == null ? null : resiliencyOptions.getMaxRetries());
    }

    @Override
    public Mono<byte[]> invoke(String actorType, String actorId, String methodName, byte[] jsonPayload) {
        DaprProtos.InvokeActorRequest req = DaprProtos.InvokeActorRequest.newBuilder().setActorType(actorType).setActorId(actorId).setMethod(methodName).setData(jsonPayload == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])jsonPayload)).build();
        return Mono.deferContextual(context -> this.createMono(it -> DaprGrpcClient.intercept(context, this.client).invokeActor(req, it))).map(r -> r.getData().toByteArray());
    }

    private DaprGrpc.DaprStub intercept(DaprGrpc.DaprStub client) {
        ClientInterceptor interceptor = new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options, Channel channel) {
                ClientCall clientCall = channel.newCall(methodDescriptor, DaprGrpcClient.this.timeoutPolicy.apply(options));
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                        String daprApiToken = (String)Properties.API_TOKEN.get();
                        if (daprApiToken != null) {
                            metadata.put(Metadata.Key.of((String)"dapr-api-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)daprApiToken);
                        }
                        super.start(responseListener, metadata);
                    }
                };
            }
        };
        return (DaprGrpc.DaprStub)client.withInterceptors(new ClientInterceptor[]{interceptor});
    }

    private static DaprGrpc.DaprStub intercept(ContextView context, DaprGrpc.DaprStub client) {
        return GrpcWrapper.intercept((ContextView)context, (DaprGrpc.DaprStub)client);
    }

    private <T> Mono<T> createMono(Consumer<StreamObserver<T>> consumer) {
        return this.retryPolicy.apply(Mono.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((MonoSink)sink))).run()));
    }

    private <T> StreamObserver<T> createStreamObserver(final MonoSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.success(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate((Throwable)new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.success();
            }
        };
    }
}

