/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import io.dapr.actors.ActorId;
import io.dapr.actors.ActorUtils;
import io.dapr.actors.client.ActorClient;
import io.dapr.actors.client.ActorProxy;
import io.dapr.actors.client.ActorProxyImpl;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ActorProxyBuilder<T> {
    private final String actorType;
    private final Class<T> clazz;
    private DaprObjectSerializer objectSerializer;
    private final ActorClient actorClient;

    public ActorProxyBuilder(Class<T> actorTypeClass, ActorClient actorClient) {
        this(ActorUtils.findActorTypeName(actorTypeClass), actorTypeClass, actorClient);
    }

    public ActorProxyBuilder(String actorType, Class<T> actorTypeClass, ActorClient actorClient) {
        if (actorType == null || actorType.isEmpty()) {
            throw new IllegalArgumentException("ActorType is required.");
        }
        if (actorTypeClass == null) {
            throw new IllegalArgumentException("ActorTypeClass is required.");
        }
        if (actorClient == null) {
            throw new IllegalArgumentException("ActorClient is required.");
        }
        this.actorType = actorType;
        this.objectSerializer = new DefaultObjectSerializer();
        this.clazz = actorTypeClass;
        this.actorClient = actorClient;
    }

    public ActorProxyBuilder<T> withObjectSerializer(DaprObjectSerializer objectSerializer) {
        if (objectSerializer == null) {
            throw new IllegalArgumentException("Serializer is required.");
        }
        this.objectSerializer = objectSerializer;
        return this;
    }

    public T build(ActorId actorId) {
        if (actorId == null) {
            throw new IllegalArgumentException("Cannot instantiate an Actor without Id.");
        }
        ActorProxyImpl proxy = new ActorProxyImpl(this.actorType, actorId, this.objectSerializer, this.actorClient);
        if (this.clazz.equals(ActorProxy.class)) {
            return (T)proxy;
        }
        return (T)Proxy.newProxyInstance(ActorProxyImpl.class.getClassLoader(), new Class[]{this.clazz}, (InvocationHandler)proxy);
    }
}

