/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import com.google.protobuf.ByteString;
import io.dapr.actors.client.DaprClient;
import io.dapr.client.resiliency.ResiliencyOptions;
import io.dapr.exceptions.DaprException;
import io.dapr.internal.grpc.DaprClientGrpcInterceptors;
import io.dapr.internal.resiliency.RetryPolicy;
import io.dapr.internal.resiliency.TimeoutPolicy;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class DaprClientImpl
implements DaprClient {
    private final RetryPolicy retryPolicy;
    private final DaprGrpc.DaprStub client;
    private final DaprClientGrpcInterceptors grpcInterceptors;
    private final Map<String, String> metadata;

    DaprClientImpl(DaprGrpc.DaprStub grpcClient, Map<String, String> metadata, ResiliencyOptions resiliencyOptions, String daprApiToken) {
        this.client = grpcClient;
        this.grpcInterceptors = new DaprClientGrpcInterceptors(daprApiToken, new TimeoutPolicy(resiliencyOptions == null ? null : resiliencyOptions.getTimeout()));
        this.retryPolicy = new RetryPolicy(resiliencyOptions == null ? null : resiliencyOptions.getMaxRetries());
        this.metadata = metadata == null ? Map.of() : metadata;
    }

    @Override
    public Mono<byte[]> invoke(String actorType, String actorId, String methodName, byte[] jsonPayload) {
        DaprProtos.InvokeActorRequest req = DaprProtos.InvokeActorRequest.newBuilder().setActorType(actorType).setActorId(actorId).setMethod(methodName).putAllMetadata(this.metadata).setData(jsonPayload == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])jsonPayload)).build();
        return Mono.deferContextual(context -> this.createMono(it -> ((DaprGrpc.DaprStub)this.grpcInterceptors.intercept((AbstractStub)this.client, context)).invokeActor(req, it))).map(r -> r.getData().toByteArray());
    }

    private <T> Mono<T> createMono(Consumer<StreamObserver<T>> consumer) {
        return this.retryPolicy.apply(Mono.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((MonoSink)sink))).run()));
    }

    private <T> StreamObserver<T> createStreamObserver(final MonoSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.success(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate((Throwable)new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.success();
            }
        };
    }
}

