/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.runtime.ActorCallType;

public class ActorMethodContext {
    private final String methodName;
    private final ActorCallType callType;

    private ActorMethodContext(String methodName, ActorCallType callType) {
        this.methodName = methodName;
        this.callType = callType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public ActorCallType getCallType() {
        return this.callType;
    }

    static ActorMethodContext createForActor(String methodName) {
        return new ActorMethodContext(methodName, ActorCallType.ACTOR_INTERFACE_METHOD);
    }

    static ActorMethodContext createForTimer(String methodName) {
        return new ActorMethodContext(methodName, ActorCallType.TIMER_METHOD);
    }

    static ActorMethodContext createForReminder(String methodName) {
        return new ActorMethodContext(methodName, ActorCallType.REMINDER_METHOD);
    }
}

