/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import io.dapr.actors.runtime.ActorReminderParams;
import io.dapr.actors.runtime.ActorRuntimeConfig;
import io.dapr.actors.runtime.ActorTimerParams;
import io.dapr.actors.runtime.ActorTypeConfig;
import io.dapr.client.ObjectSerializer;
import io.dapr.utils.DurationUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;

public class ActorObjectSerializer
extends ObjectSerializer {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public byte[] serialize(Object state) throws IOException {
        if (state == null) {
            return null;
        }
        if (state.getClass() == ActorTimerParams.class) {
            return this.serialize((ActorTimerParams)state);
        }
        if (state.getClass() == ActorReminderParams.class) {
            return this.serialize((ActorReminderParams)state);
        }
        if (state.getClass() == ActorRuntimeConfig.class) {
            return this.serialize((ActorRuntimeConfig)state);
        }
        return super.serialize(state);
    }

    private byte[] serialize(ActorTimerParams timer) throws IOException {
        if (timer == null) {
            return null;
        }
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)writer);
            generator.writeStartObject();
            generator.writeStringField("dueTime", DurationUtils.convertDurationToDaprFormat((Duration)timer.getDueTime()));
            generator.writeStringField("period", DurationUtils.convertDurationToDaprFormat((Duration)timer.getPeriod()));
            generator.writeStringField("callback", timer.getCallback());
            if (timer.getData() != null) {
                generator.writeBinaryField("data", timer.getData());
            }
            generator.writeEndObject();
            generator.close();
            writer.flush();
            byte[] byArray = writer.toByteArray();
            return byArray;
        }
    }

    private byte[] serialize(ActorReminderParams reminder) throws IOException {
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)writer);
            generator.writeStartObject();
            generator.writeStringField("dueTime", DurationUtils.convertDurationToDaprFormat((Duration)reminder.getDueTime()));
            generator.writeStringField("period", DurationUtils.convertDurationToDaprFormat((Duration)reminder.getPeriod()));
            if (reminder.getData() != null) {
                generator.writeBinaryField("data", reminder.getData());
            }
            generator.writeEndObject();
            generator.close();
            writer.flush();
            byte[] byArray = writer.toByteArray();
            return byArray;
        }
    }

    private byte[] serialize(ActorRuntimeConfig config) throws IOException {
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)writer);
            generator.writeStartObject();
            generator.writeArrayFieldStart("entities");
            for (String actorClass : config.getRegisteredActorTypes()) {
                generator.writeString(actorClass);
            }
            generator.writeEndArray();
            if (config.getActorIdleTimeout() != null) {
                generator.writeStringField("actorIdleTimeout", DurationUtils.convertDurationToDaprFormat((Duration)config.getActorIdleTimeout()));
            }
            if (config.getActorScanInterval() != null) {
                generator.writeStringField("actorScanInterval", DurationUtils.convertDurationToDaprFormat((Duration)config.getActorScanInterval()));
            }
            if (config.getDrainOngoingCallTimeout() != null) {
                generator.writeStringField("drainOngoingCallTimeout", DurationUtils.convertDurationToDaprFormat((Duration)config.getDrainOngoingCallTimeout()));
            }
            if (config.getDrainBalancedActors() != null) {
                generator.writeBooleanField("drainBalancedActors", config.getDrainBalancedActors().booleanValue());
            }
            if (config.getRemindersStoragePartitions() != null) {
                generator.writeNumberField("remindersStoragePartitions", config.getRemindersStoragePartitions().intValue());
            }
            if (!config.getActorTypeConfigs().isEmpty()) {
                generator.writeArrayFieldStart("entitiesConfig");
                for (ActorTypeConfig actorTypeConfig : config.getActorTypeConfigs()) {
                    generator.writeStartObject();
                    if (actorTypeConfig.getActorTypeName() != null) {
                        generator.writeArrayFieldStart("entities");
                        generator.writeString(actorTypeConfig.getActorTypeName());
                        generator.writeEndArray();
                    }
                    if (actorTypeConfig.getActorIdleTimeout() != null) {
                        generator.writeStringField("actorIdleTimeout", DurationUtils.convertDurationToDaprFormat((Duration)actorTypeConfig.getActorIdleTimeout()));
                    }
                    if (actorTypeConfig.getActorScanInterval() != null) {
                        generator.writeStringField("actorScanInterval", DurationUtils.convertDurationToDaprFormat((Duration)actorTypeConfig.getActorScanInterval()));
                    }
                    if (actorTypeConfig.getDrainOngoingCallTimeout() != null) {
                        generator.writeStringField("drainOngoingCallTimeout", DurationUtils.convertDurationToDaprFormat((Duration)actorTypeConfig.getDrainOngoingCallTimeout()));
                    }
                    if (actorTypeConfig.getDrainBalancedActors() != null) {
                        generator.writeBooleanField("drainBalancedActors", actorTypeConfig.getDrainBalancedActors().booleanValue());
                    }
                    if (actorTypeConfig.getRemindersStoragePartitions() != null) {
                        generator.writeNumberField("remindersStoragePartitions", actorTypeConfig.getRemindersStoragePartitions().intValue());
                    }
                    generator.writeEndObject();
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
            generator.close();
            writer.flush();
            Object object = writer.toByteArray();
            return object;
        }
    }

    public <T> T deserialize(byte[] content, Class<T> clazz) throws IOException {
        if (clazz == ActorTimerParams.class) {
            return (T)this.deserializeActorTimer(content);
        }
        if (clazz == ActorReminderParams.class) {
            return (T)this.deserializeActorReminder(content);
        }
        return (T)super.deserialize(content, clazz);
    }

    private ActorTimerParams deserializeActorTimer(byte[] value) throws IOException {
        if (value == null) {
            return null;
        }
        JsonNode node = OBJECT_MAPPER.readTree(value);
        String callback = node.get("callback").asText();
        Duration dueTime = ActorObjectSerializer.extractDurationOrNull(node, "dueTime");
        Duration period = ActorObjectSerializer.extractDurationOrNull(node, "period");
        byte[] data = node.get("data") != null ? node.get("data").binaryValue() : null;
        return new ActorTimerParams(callback, data, dueTime, period);
    }

    private ActorReminderParams deserializeActorReminder(byte[] value) throws IOException {
        if (value == null) {
            return null;
        }
        JsonNode node = OBJECT_MAPPER.readTree(value);
        Duration dueTime = ActorObjectSerializer.extractDurationOrNull(node, "dueTime");
        Duration period = ActorObjectSerializer.extractDurationOrNull(node, "period");
        byte[] data = node.get("data") != null ? node.get("data").binaryValue() : null;
        return new ActorReminderParams(data, dueTime, period);
    }

    private static Duration extractDurationOrNull(JsonNode node, String name) {
        JsonNode valueNode = node.get(name);
        if (valueNode == null) {
            return null;
        }
        return DurationUtils.convertDurationFromDaprFormat((String)valueNode.asText());
    }
}

