/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import java.time.Duration;

final class ActorReminderParams {
    private static final Duration MIN_TIME_PERIOD = Duration.ofMillis(-1L);
    private final byte[] data;
    private final Duration dueTime;
    private final Duration period;

    ActorReminderParams(byte[] data, Duration dueTime, Duration period) {
        ActorReminderParams.validateDueTime("DueTime", dueTime);
        ActorReminderParams.validatePeriod("Period", period);
        this.data = data;
        this.dueTime = dueTime;
        this.period = period;
    }

    Duration getDueTime() {
        return this.dueTime;
    }

    Duration getPeriod() {
        return this.period;
    }

    byte[] getData() {
        return this.data;
    }

    private static void validateDueTime(String argName, Duration value) {
        if (value.compareTo(Duration.ZERO) < 0) {
            String message = String.format("argName: %s - Duration toMillis() - specified value must be greater than %s", argName, Duration.ZERO);
            throw new IllegalArgumentException(message);
        }
    }

    private static void validatePeriod(String argName, Duration value) throws IllegalArgumentException {
        if (value.compareTo(MIN_TIME_PERIOD) < 0) {
            String message = String.format("argName: %s - Duration toMillis() - specified value must be greater than %s", argName, MIN_TIME_PERIOD);
            throw new IllegalArgumentException(message);
        }
    }
}

