/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorId;
import io.dapr.actors.ActorTrace;
import io.dapr.actors.runtime.AbstractActor;
import io.dapr.actors.runtime.ActorFactory;
import io.dapr.actors.runtime.ActorManager;
import io.dapr.actors.runtime.ActorObjectSerializer;
import io.dapr.actors.runtime.ActorRuntimeConfig;
import io.dapr.actors.runtime.ActorRuntimeContext;
import io.dapr.actors.runtime.ActorTypeInformation;
import io.dapr.actors.runtime.DaprClient;
import io.dapr.actors.runtime.DaprClientImpl;
import io.dapr.actors.runtime.DaprStateAsyncProvider;
import io.dapr.actors.runtime.DefaultActorFactory;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.Version;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.core.publisher.Mono;

public class ActorRuntime
implements Closeable {
    private static final ActorObjectSerializer INTERNAL_SERIALIZER = new ActorObjectSerializer();
    private static final String TRACE_TYPE = "ActorRuntime";
    private static final ActorTrace ACTOR_TRACE = new ActorTrace();
    private static volatile ActorRuntime instance;
    private final ManagedChannel channel;
    private final ActorRuntimeConfig config;
    private final DaprClient daprClient;
    private final ConcurrentMap<String, ActorManager> actorManagers;

    private ActorRuntime() throws IllegalStateException {
        this(ActorRuntime.buildManagedChannel());
    }

    private ActorRuntime(ManagedChannel channel) throws IllegalStateException {
        this(channel, ActorRuntime.buildDaprClient(channel));
    }

    private ActorRuntime(ManagedChannel channel, DaprClient daprClient) throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("ActorRuntime should only be constructed once");
        }
        this.config = new ActorRuntimeConfig();
        this.actorManagers = new ConcurrentHashMap<String, ActorManager>();
        this.daprClient = daprClient;
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActorRuntime getInstance() {
        if (instance != null) return instance;
        Class<ActorRuntime> clazz = ActorRuntime.class;
        synchronized (ActorRuntime.class) {
            if (instance != null) return instance;
            instance = new ActorRuntime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ActorRuntimeConfig getConfig() {
        return this.config;
    }

    public byte[] serializeConfig() throws IOException {
        return INTERNAL_SERIALIZER.serialize((Object)this.config);
    }

    public <T extends AbstractActor> void registerActor(Class<T> clazz) {
        this.registerActor(clazz, (DaprObjectSerializer)new DefaultObjectSerializer(), (DaprObjectSerializer)new DefaultObjectSerializer());
    }

    public <T extends AbstractActor> void registerActor(Class<T> clazz, ActorFactory<T> actorFactory) {
        this.registerActor(clazz, actorFactory, (DaprObjectSerializer)new DefaultObjectSerializer(), (DaprObjectSerializer)new DefaultObjectSerializer());
    }

    public <T extends AbstractActor> void registerActor(Class<T> clazz, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        this.registerActor(clazz, new DefaultActorFactory(), objectSerializer, stateSerializer);
    }

    public <T extends AbstractActor> void registerActor(Class<T> clazz, ActorFactory<T> actorFactory, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class is required.");
        }
        if (actorFactory == null) {
            throw new IllegalArgumentException("Actor factory is required.");
        }
        if (objectSerializer == null) {
            throw new IllegalArgumentException("Object serializer is required.");
        }
        if (stateSerializer == null) {
            throw new IllegalArgumentException("State serializer is required.");
        }
        ActorTypeInformation actorTypeInfo = ActorTypeInformation.create(clazz);
        this.actorManagers.computeIfAbsent(actorTypeInfo.getName(), k -> {
            ActorRuntimeContext context = new ActorRuntimeContext(this, objectSerializer, actorFactory, actorTypeInfo, this.daprClient, new DaprStateAsyncProvider(this.daprClient, stateSerializer));
            this.config.addRegisteredActorType(actorTypeInfo.getName());
            return new ActorManager(context);
        });
    }

    public Mono<Void> deactivate(String actorTypeName, String actorId) {
        return Mono.fromSupplier(() -> this.getActorManager(actorTypeName)).flatMap(m -> m.deactivateActor(new ActorId(actorId)));
    }

    public Mono<byte[]> invoke(String actorTypeName, String actorId, String actorMethodName, byte[] payload) {
        ActorId id = new ActorId(actorId);
        return Mono.fromSupplier(() -> this.getActorManager(actorTypeName)).flatMap(m -> m.activateActor(id).thenReturn(m)).flatMap(m -> ((ActorManager)m).invokeMethod(id, actorMethodName, payload));
    }

    public Mono<Void> invokeReminder(String actorTypeName, String actorId, String reminderName, byte[] params) {
        ActorId id = new ActorId(actorId);
        return Mono.fromSupplier(() -> this.getActorManager(actorTypeName)).flatMap(m -> m.activateActor(id).thenReturn(m)).flatMap(m -> ((ActorManager)m).invokeReminder(new ActorId(actorId), reminderName, params));
    }

    public Mono<Void> invokeTimer(String actorTypeName, String actorId, String timerName, byte[] params) {
        ActorId id = new ActorId(actorId);
        return Mono.fromSupplier(() -> this.getActorManager(actorTypeName)).flatMap(m -> m.activateActor(id).thenReturn(m)).flatMap(m -> ((ActorManager)m).invokeTimer(new ActorId(actorId), timerName, params));
    }

    private ActorManager getActorManager(String actorTypeName) {
        ActorManager actorManager = (ActorManager)this.actorManagers.get(actorTypeName);
        if (actorManager == null) {
            String errorMsg = String.format("Actor type %s is not registered with Actor runtime.", actorTypeName);
            ACTOR_TRACE.writeError(TRACE_TYPE, actorTypeName, "Actor type is not registered with runtime.", new Object[0]);
            throw new IllegalArgumentException(errorMsg);
        }
        return actorManager;
    }

    private static DaprClient buildDaprClient(ManagedChannel channel) {
        return new DaprClientImpl(channel);
    }

    private static ManagedChannel buildManagedChannel() {
        int port = (Integer)Properties.GRPC_PORT.get();
        if (port <= 0) {
            throw new IllegalStateException("Invalid port.");
        }
        return ManagedChannelBuilder.forAddress((String)((String)Properties.SIDECAR_IP.get()), (int)port).usePlaintext().userAgent(Version.getSdkVersion()).build();
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown();
        }
    }
}

