/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.runtime.ActorTypeConfig;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActorRuntimeConfig {
    private List<String> registeredActorTypes = new CopyOnWriteArrayList<String>();
    private volatile Duration actorIdleTimeout;
    private volatile Duration actorScanInterval;
    private volatile Duration drainOngoingCallTimeout;
    private volatile Boolean drainBalancedActors;
    private volatile Integer remindersStoragePartitions;
    private volatile List<ActorTypeConfig> actorTypeConfigs = new CopyOnWriteArrayList<ActorTypeConfig>();

    ActorRuntimeConfig() {
    }

    ActorRuntimeConfig addRegisteredActorType(String actorTypeName) {
        if (actorTypeName == null) {
            throw new IllegalArgumentException("Registered actor must have a type name.");
        }
        this.registeredActorTypes.add(actorTypeName);
        return this;
    }

    Collection<String> getRegisteredActorTypes() {
        return Collections.unmodifiableCollection(this.registeredActorTypes);
    }

    public Duration getActorIdleTimeout() {
        return this.actorIdleTimeout;
    }

    public ActorRuntimeConfig setActorIdleTimeout(Duration actorIdleTimeout) {
        this.actorIdleTimeout = actorIdleTimeout;
        return this;
    }

    public Duration getActorScanInterval() {
        return this.actorScanInterval;
    }

    public ActorRuntimeConfig setActorScanInterval(Duration actorScanInterval) {
        this.actorScanInterval = actorScanInterval;
        return this;
    }

    public Duration getDrainOngoingCallTimeout() {
        return this.drainOngoingCallTimeout;
    }

    public ActorRuntimeConfig setDrainOngoingCallTimeout(Duration drainOngoingCallTimeout) {
        this.drainOngoingCallTimeout = drainOngoingCallTimeout;
        return this;
    }

    public Boolean getDrainBalancedActors() {
        return this.drainBalancedActors;
    }

    public ActorRuntimeConfig setDrainBalancedActors(Boolean drainBalancedActors) {
        this.drainBalancedActors = drainBalancedActors;
        return this;
    }

    public Integer getRemindersStoragePartitions() {
        return this.remindersStoragePartitions;
    }

    public ActorRuntimeConfig setRemindersStoragePartitions(Integer remindersStoragePartitions) {
        this.remindersStoragePartitions = remindersStoragePartitions;
        return this;
    }

    ActorRuntimeConfig addActorTypeConfig(ActorTypeConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Add actor type config failed.");
        }
        this.actorTypeConfigs.add(config);
        return this;
    }

    Collection<ActorTypeConfig> getActorTypeConfigs() {
        return Collections.unmodifiableCollection(this.actorTypeConfigs);
    }
}

