/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorId;
import io.dapr.actors.runtime.ActorStateChange;
import io.dapr.actors.runtime.ActorStateChangeKind;
import io.dapr.actors.runtime.DaprStateAsyncProvider;
import io.dapr.utils.TypeRef;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class ActorStateManager {
    private final DaprStateAsyncProvider stateProvider;
    private final String actorTypeName;
    private final ActorId actorId;
    private final Map<String, StateChangeMetadata> stateChangeTracker;

    ActorStateManager(DaprStateAsyncProvider stateProvider, String actorTypeName, ActorId actorId) {
        this.stateProvider = stateProvider;
        this.actorTypeName = actorTypeName;
        this.actorId = actorId;
        this.stateChangeTracker = new ConcurrentHashMap<String, StateChangeMetadata>();
    }

    public <T> Mono<Void> add(String stateName, T value) {
        return Mono.fromSupplier(() -> {
            if (stateName == null) {
                throw new IllegalArgumentException("State's name cannot be null.");
            }
            return null;
        }).then(this.stateProvider.contains(this.actorTypeName, this.actorId, stateName).map(exists -> {
            if (this.stateChangeTracker.containsKey(stateName)) {
                StateChangeMetadata metadata = this.stateChangeTracker.get(stateName);
                if (metadata.kind == ActorStateChangeKind.REMOVE) {
                    this.stateChangeTracker.put(stateName, new StateChangeMetadata(ActorStateChangeKind.UPDATE, value));
                    return true;
                }
                throw new IllegalStateException("Duplicate cached state: " + stateName);
            }
            if (exists.booleanValue()) {
                throw new IllegalStateException("Duplicate state: " + stateName);
            }
            this.stateChangeTracker.put(stateName, new StateChangeMetadata(ActorStateChangeKind.ADD, value));
            return true;
        })).then();
    }

    public <T> Mono<T> get(String stateName, Class<T> clazz) {
        return this.get(stateName, TypeRef.get(clazz));
    }

    public <T> Mono<T> get(String stateName, TypeRef<T> type) {
        return Mono.fromSupplier(() -> {
            if (stateName == null) {
                throw new IllegalArgumentException("State's name cannot be null.");
            }
            if (this.stateChangeTracker.containsKey(stateName)) {
                StateChangeMetadata metadata = this.stateChangeTracker.get(stateName);
                if (metadata.kind == ActorStateChangeKind.REMOVE) {
                    throw new NoSuchElementException("State is marked for removal: " + stateName);
                }
                return metadata.value;
            }
            return null;
        }).switchIfEmpty(this.stateProvider.load(this.actorTypeName, this.actorId, stateName, type).switchIfEmpty(Mono.error((Throwable)new NoSuchElementException("State not found: " + stateName))).map(v -> {
            this.stateChangeTracker.put(stateName, new StateChangeMetadata(ActorStateChangeKind.NONE, v));
            return v;
        }));
    }

    public <T> Mono<Void> set(String stateName, T value) {
        return Mono.fromSupplier(() -> {
            if (stateName == null) {
                throw new IllegalArgumentException("State's name cannot be null.");
            }
            if (this.stateChangeTracker.containsKey(stateName)) {
                StateChangeMetadata metadata = this.stateChangeTracker.get(stateName);
                ActorStateChangeKind kind = metadata.kind;
                if (kind == ActorStateChangeKind.NONE || kind == ActorStateChangeKind.REMOVE) {
                    kind = ActorStateChangeKind.UPDATE;
                }
                this.stateChangeTracker.put(stateName, new StateChangeMetadata(kind, value));
                return true;
            }
            return false;
        }).filter(x -> x).switchIfEmpty(this.stateProvider.contains(this.actorTypeName, this.actorId, stateName).map(exists -> {
            this.stateChangeTracker.put(stateName, new StateChangeMetadata(exists != false ? ActorStateChangeKind.UPDATE : ActorStateChangeKind.ADD, value));
            return exists;
        })).then();
    }

    public Mono<Void> remove(String stateName) {
        return Mono.fromSupplier(() -> {
            if (stateName == null) {
                throw new IllegalArgumentException("State's name cannot be null.");
            }
            if (this.stateChangeTracker.containsKey(stateName)) {
                StateChangeMetadata metadata = this.stateChangeTracker.get(stateName);
                if (metadata.kind == ActorStateChangeKind.REMOVE) {
                    return true;
                }
                if (metadata.kind == ActorStateChangeKind.ADD) {
                    this.stateChangeTracker.remove(stateName);
                    return true;
                }
                this.stateChangeTracker.put(stateName, new StateChangeMetadata(ActorStateChangeKind.REMOVE, null));
                return true;
            }
            return false;
        }).filter(x -> x).switchIfEmpty(this.stateProvider.contains(this.actorTypeName, this.actorId, stateName)).filter(exists -> exists).map(exists -> {
            this.stateChangeTracker.put(stateName, new StateChangeMetadata(ActorStateChangeKind.REMOVE, null));
            return exists;
        }).then();
    }

    public Mono<Boolean> contains(String stateName) {
        return Mono.fromSupplier(() -> {
            if (stateName == null) {
                throw new IllegalArgumentException("State's name cannot be null.");
            }
            return this.stateChangeTracker.get(stateName);
        }).map(metadata -> {
            if (metadata.kind == ActorStateChangeKind.REMOVE) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }).switchIfEmpty(this.stateProvider.contains(this.actorTypeName, this.actorId, stateName));
    }

    public Mono<Void> save() {
        return Mono.fromSupplier(() -> {
            if (this.stateChangeTracker.isEmpty()) {
                return null;
            }
            ArrayList<ActorStateChange> changes = new ArrayList<ActorStateChange>();
            for (Map.Entry<String, StateChangeMetadata> tuple : this.stateChangeTracker.entrySet()) {
                if (tuple.getValue().kind == ActorStateChangeKind.NONE) continue;
                changes.add(new ActorStateChange(tuple.getKey(), tuple.getValue().value, tuple.getValue().kind));
            }
            return changes.toArray(new ActorStateChange[0]);
        }).flatMap(changes -> this.stateProvider.apply(this.actorTypeName, this.actorId, (ActorStateChange)changes)).then(Mono.fromRunnable(() -> this.flush()));
    }

    public void clear() {
        this.stateChangeTracker.clear();
    }

    private void flush() {
        for (Map.Entry<String, StateChangeMetadata> tuple : this.stateChangeTracker.entrySet()) {
            String stateName = tuple.getKey();
            if (tuple.getValue().kind == ActorStateChangeKind.REMOVE) {
                this.stateChangeTracker.remove(stateName);
                continue;
            }
            StateChangeMetadata metadata = new StateChangeMetadata(ActorStateChangeKind.NONE, tuple.getValue().value);
            this.stateChangeTracker.put(stateName, metadata);
        }
    }

    private static final class StateChangeMetadata {
        private final ActorStateChangeKind kind;
        private final Object value;

        private StateChangeMetadata(ActorStateChangeKind kind, Object value) {
            this.kind = kind;
            this.value = value;
        }
    }
}

