/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.actors.ActorId;
import io.dapr.actors.runtime.ActorStateChange;
import io.dapr.actors.runtime.ActorStateChangeKind;
import io.dapr.actors.runtime.ActorStateOperation;
import io.dapr.actors.runtime.DaprClient;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import reactor.core.publisher.Mono;

class DaprStateAsyncProvider {
    private static final Charset CHARSET = (Charset)Properties.STRING_CHARSET.get();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final DaprClient daprClient;
    private final DaprObjectSerializer stateSerializer;
    private final boolean isStateSerializerDefault;

    DaprStateAsyncProvider(DaprClient daprClient, DaprObjectSerializer stateSerializer) {
        this.daprClient = daprClient;
        this.stateSerializer = stateSerializer;
        this.isStateSerializerDefault = stateSerializer.getClass() == DefaultObjectSerializer.class;
    }

    <T> Mono<T> load(String actorType, ActorId actorId, String stateName, TypeRef<T> type) {
        Mono<byte[]> result = this.daprClient.getState(actorType, actorId.toString(), stateName);
        return result.flatMap(s -> {
            try {
                if (s == null) {
                    return Mono.empty();
                }
                Object response = this.stateSerializer.deserialize(s, type);
                if (this.isStateSerializerDefault && response instanceof byte[]) {
                    if (((byte[])s).length == 0) {
                        return Mono.empty();
                    }
                    response = OBJECT_MAPPER.readValue(s, byte[].class);
                }
                if (response == null) {
                    return Mono.empty();
                }
                return Mono.just((Object)response);
            }
            catch (IOException e) {
                return Mono.error((Throwable)new RuntimeException(e));
            }
        });
    }

    Mono<Boolean> contains(String actorType, ActorId actorId, String stateName) {
        Mono<byte[]> result = this.daprClient.getState(actorType, actorId.toString(), stateName);
        return result.map(s -> ((byte[])s).length > 0).defaultIfEmpty((Object)false);
    }

    Mono<Void> apply(String actorType, ActorId actorId, ActorStateChange ... stateChanges) {
        if (stateChanges == null || stateChanges.length == 0) {
            return Mono.empty();
        }
        ArrayList<ActorStateOperation> operations = new ArrayList<ActorStateOperation>(stateChanges.length);
        for (ActorStateChange stateChange : stateChanges) {
            String operationName;
            if (stateChange == null || stateChange.getChangeKind() == null || (operationName = stateChange.getChangeKind().getDaprStateChangeOperation()) == null || operationName.length() == 0) continue;
            String key = stateChange.getStateName();
            Object value = null;
            if (stateChange.getChangeKind() == ActorStateChangeKind.UPDATE || stateChange.getChangeKind() == ActorStateChangeKind.ADD) {
                try {
                    byte[] data = this.stateSerializer.serialize(stateChange.getValue());
                    if (data != null) {
                        value = this.isStateSerializerDefault && !(stateChange.getValue() instanceof byte[]) ? (Object)new String(data, CHARSET) : data;
                    }
                }
                catch (IOException e) {
                    return Mono.error((Throwable)e);
                }
            }
            operations.add(new ActorStateOperation(operationName, key, value));
        }
        return this.daprClient.saveStateTransactionally(actorType, actorId.toString(), operations);
    }
}

