/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorId;
import io.dapr.actors.ActorTrace;
import io.dapr.actors.runtime.AbstractActor;
import io.dapr.actors.runtime.ActorFactory;
import io.dapr.actors.runtime.ActorRuntimeContext;
import java.lang.reflect.Constructor;

class DefaultActorFactory<T extends AbstractActor>
implements ActorFactory<T> {
    private static final ActorTrace ACTOR_TRACE = new ActorTrace();

    DefaultActorFactory() {
    }

    @Override
    public T createActor(ActorRuntimeContext<T> actorRuntimeContext, ActorId actorId) {
        try {
            if (actorRuntimeContext == null) {
                return null;
            }
            Constructor<T> constructor = actorRuntimeContext.getActorTypeInformation().getImplementationClass().getConstructor(ActorRuntimeContext.class, ActorId.class);
            return (T)((AbstractActor)constructor.newInstance(actorRuntimeContext, actorId));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            ACTOR_TRACE.writeError(actorRuntimeContext.getActorTypeInformation().getName(), actorId.toString(), "Failed to create actor instance.", new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

