/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import io.dapr.actors.client.DaprClient;
import io.dapr.actors.client.DaprClientImpl;
import io.dapr.client.resiliency.ResiliencyOptions;
import io.dapr.config.Properties;
import io.dapr.utils.NetworkUtils;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.Map;
import reactor.core.publisher.Mono;

public class ActorClient
implements AutoCloseable {
    private final ManagedChannel grpcManagedChannel;
    private final DaprClient daprClient;

    public ActorClient() {
        this(new Properties(), null);
    }

    public ActorClient(ResiliencyOptions resiliencyOptions) {
        this(new Properties(), resiliencyOptions);
    }

    public ActorClient(Properties overrideProperties) {
        this(overrideProperties, null);
    }

    public ActorClient(Properties overrideProperties, ResiliencyOptions resiliencyOptions) {
        this(overrideProperties, null, resiliencyOptions);
    }

    public ActorClient(Properties overrideProperties, Map<String, String> metadata, ResiliencyOptions resiliencyOptions) {
        this(NetworkUtils.buildGrpcManagedChannel((Properties)overrideProperties, (ClientInterceptor[])new ClientInterceptor[0]), metadata, resiliencyOptions, (String)overrideProperties.getValue(Properties.API_TOKEN));
    }

    private ActorClient(ManagedChannel grpcManagedChannel, Map<String, String> metadata, ResiliencyOptions resiliencyOptions, String daprApiToken) {
        this.grpcManagedChannel = grpcManagedChannel;
        this.daprClient = ActorClient.buildDaprClient((Channel)grpcManagedChannel, metadata, resiliencyOptions, daprApiToken);
    }

    Mono<byte[]> invoke(String actorType, String actorId, String methodName, byte[] jsonPayload) {
        return this.daprClient.invoke(actorType, actorId, methodName, jsonPayload);
    }

    @Override
    public void close() {
        if (this.grpcManagedChannel != null && !this.grpcManagedChannel.isShutdown()) {
            this.grpcManagedChannel.shutdown();
        }
    }

    private static DaprClient buildDaprClient(Channel grpcManagedChannel, Map<String, String> metadata, ResiliencyOptions resiliencyOptions, String daprApiToken) {
        return new DaprClientImpl(DaprGrpc.newStub((Channel)grpcManagedChannel), metadata == null ? null : Collections.unmodifiableMap(metadata), resiliencyOptions, daprApiToken);
    }
}

