/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import io.dapr.actors.runtime.ActorReminderParams;
import io.dapr.actors.runtime.ActorStateOperation;
import io.dapr.actors.runtime.ActorTimerParams;
import io.dapr.actors.runtime.DaprClient;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.dapr.utils.DurationUtils;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class DaprClientImpl
implements DaprClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Charset CHARSET = (Charset)Properties.STRING_CHARSET.get();
    private DaprGrpc.DaprStub client;

    DaprClientImpl(ManagedChannel channel) {
        this(DaprGrpc.newStub((Channel)channel));
    }

    DaprClientImpl(DaprGrpc.DaprStub daprStubClient) {
        this.client = daprStubClient;
    }

    @Override
    public Mono<byte[]> getState(String actorType, String actorId, String keyName) {
        DaprProtos.GetActorStateRequest req = DaprProtos.GetActorStateRequest.newBuilder().setActorType(actorType).setActorId(actorId).setKey(keyName).build();
        return Mono.create(it -> this.client.getActorState(req, this.createStreamObserver((MonoSink)it))).map(r -> r.getData().toByteArray());
    }

    @Override
    public Mono<Void> saveStateTransactionally(String actorType, String actorId, List<ActorStateOperation> operations) {
        ArrayList<DaprProtos.TransactionalActorStateOperation> grpcOps = new ArrayList<DaprProtos.TransactionalActorStateOperation>();
        for (ActorStateOperation op : operations) {
            String operationType = op.getOperationType();
            String key = op.getKey();
            Object value = op.getValue();
            DaprProtos.TransactionalActorStateOperation.Builder opBuilder = DaprProtos.TransactionalActorStateOperation.newBuilder().setOperationType(operationType).setKey(key);
            if (value != null) {
                if (value instanceof String) {
                    opBuilder.setValue(Any.newBuilder().setValue(ByteString.copyFrom((String)((String)value), (Charset)CHARSET)));
                } else if (value instanceof byte[]) {
                    try {
                        String base64 = OBJECT_MAPPER.writeValueAsString(value);
                        opBuilder.setValue(Any.newBuilder().setValue(ByteString.copyFrom((String)base64, (Charset)CHARSET)));
                    }
                    catch (IOException e) {
                        return Mono.error((Throwable)e);
                    }
                } else {
                    return Mono.error(() -> {
                        throw new IllegalArgumentException("Actor state value must be String or byte[]");
                    });
                }
            }
            grpcOps.add(opBuilder.build());
        }
        DaprProtos.ExecuteActorStateTransactionRequest req = DaprProtos.ExecuteActorStateTransactionRequest.newBuilder().setActorType(actorType).setActorId(actorId).addAllOperations(grpcOps).build();
        return Mono.create(it -> this.client.executeActorStateTransaction(req, this.createStreamObserver((MonoSink)it))).then();
    }

    @Override
    public Mono<Void> registerReminder(String actorType, String actorId, String reminderName, ActorReminderParams reminderParams) {
        DaprProtos.RegisterActorReminderRequest req = DaprProtos.RegisterActorReminderRequest.newBuilder().setActorType(actorType).setActorId(actorId).setName(reminderName).setData(ByteString.copyFrom((byte[])reminderParams.getData())).setDueTime(DurationUtils.convertDurationToDaprFormat((Duration)reminderParams.getDueTime())).setPeriod(DurationUtils.convertDurationToDaprFormat((Duration)reminderParams.getPeriod())).build();
        return Mono.create(it -> this.client.registerActorReminder(req, this.createStreamObserver((MonoSink)it))).then().then();
    }

    @Override
    public Mono<Void> unregisterReminder(String actorType, String actorId, String reminderName) {
        DaprProtos.UnregisterActorReminderRequest req = DaprProtos.UnregisterActorReminderRequest.newBuilder().setActorType(actorType).setActorId(actorId).setName(reminderName).build();
        return Mono.create(it -> this.client.unregisterActorReminder(req, this.createStreamObserver((MonoSink)it))).then().then();
    }

    @Override
    public Mono<Void> registerTimer(String actorType, String actorId, String timerName, ActorTimerParams timerParams) {
        DaprProtos.RegisterActorTimerRequest req = DaprProtos.RegisterActorTimerRequest.newBuilder().setActorType(actorType).setActorId(actorId).setName(timerName).setCallback(timerParams.getCallback()).setData(ByteString.copyFrom((byte[])timerParams.getData())).setDueTime(DurationUtils.convertDurationToDaprFormat((Duration)timerParams.getDueTime())).setPeriod(DurationUtils.convertDurationToDaprFormat((Duration)timerParams.getPeriod())).build();
        return Mono.create(it -> this.client.registerActorTimer(req, this.createStreamObserver((MonoSink)it))).then().then();
    }

    @Override
    public Mono<Void> unregisterTimer(String actorType, String actorId, String timerName) {
        DaprProtos.UnregisterActorTimerRequest req = DaprProtos.UnregisterActorTimerRequest.newBuilder().setActorType(actorType).setActorId(actorId).setName(timerName).build();
        return Mono.create(it -> this.client.unregisterActorTimer(req, this.createStreamObserver((MonoSink)it))).then().then();
    }

    private <T> StreamObserver<T> createStreamObserver(final MonoSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.success(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate((Throwable)new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.success();
            }
        };
    }
}

