/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorId;
import io.dapr.actors.ActorTrace;
import io.dapr.actors.runtime.ActorMethodContext;
import io.dapr.actors.runtime.ActorObjectSerializer;
import io.dapr.actors.runtime.ActorReminderParams;
import io.dapr.actors.runtime.ActorRuntimeContext;
import io.dapr.actors.runtime.ActorStateManager;
import io.dapr.actors.runtime.ActorTimerParams;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import reactor.core.publisher.Mono;

public abstract class AbstractActor {
    private static final ActorObjectSerializer INTERNAL_SERIALIZER = new ActorObjectSerializer();
    private static final String TRACE_TYPE = "Actor";
    private final ActorRuntimeContext<?> actorRuntimeContext;
    private final ActorId id;
    private final ActorTrace actorTrace;
    private final ActorStateManager actorStateManager;
    private boolean started;

    protected AbstractActor(ActorRuntimeContext runtimeContext, ActorId id) {
        this.actorRuntimeContext = runtimeContext;
        this.id = id;
        this.actorStateManager = new ActorStateManager(runtimeContext.getStateProvider(), runtimeContext.getActorTypeInformation().getName(), id);
        this.actorTrace = runtimeContext.getActorTrace();
        this.started = false;
    }

    protected ActorId getId() {
        return this.id;
    }

    String getType() {
        return this.actorRuntimeContext.getActorTypeInformation().getName();
    }

    protected ActorStateManager getActorStateManager() {
        return this.actorStateManager;
    }

    protected <T> Mono<Void> registerReminder(String reminderName, T state, Duration dueTime, Duration period) {
        try {
            byte[] data = this.actorRuntimeContext.getObjectSerializer().serialize(state);
            ActorReminderParams params = new ActorReminderParams(data, dueTime, period);
            return this.actorRuntimeContext.getDaprClient().registerReminder(this.actorRuntimeContext.getActorTypeInformation().getName(), this.id.toString(), reminderName, params);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    protected <T> Mono<String> registerActorTimer(String timerName, String callback, T state, Duration dueTime, Duration period) {
        try {
            if (callback == null || callback.isEmpty()) {
                throw new IllegalArgumentException("Timer requires a callback function.");
            }
            String name = timerName;
            if (timerName == null || timerName.isEmpty()) {
                name = String.format("%s_Timer_%s", this.id.toString(), UUID.randomUUID().toString());
            }
            byte[] data = this.actorRuntimeContext.getObjectSerializer().serialize(state);
            ActorTimerParams actorTimer = new ActorTimerParams(callback, data, dueTime, period);
            return this.actorRuntimeContext.getDaprClient().registerTimer(this.actorRuntimeContext.getActorTypeInformation().getName(), this.id.toString(), name, actorTimer).thenReturn((Object)name);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    protected Mono<Void> unregisterTimer(String timerName) {
        return this.actorRuntimeContext.getDaprClient().unregisterTimer(this.actorRuntimeContext.getActorTypeInformation().getName(), this.id.toString(), timerName);
    }

    protected Mono<Void> unregisterReminder(String reminderName) {
        return this.actorRuntimeContext.getDaprClient().unregisterReminder(this.actorRuntimeContext.getActorTypeInformation().getName(), this.id.toString(), reminderName);
    }

    protected Mono<Void> onActivate() {
        return Mono.empty();
    }

    protected Mono<Void> onDeactivate() {
        return Mono.empty();
    }

    protected Mono<Void> onPreActorMethod(ActorMethodContext actorMethodContext) {
        return Mono.empty();
    }

    protected Mono<Void> onPostActorMethod(ActorMethodContext actorMethodContext) {
        return Mono.empty();
    }

    protected Mono<Void> saveState() {
        return this.actorStateManager.save();
    }

    void rollback() {
        if (!this.started) {
            throw new IllegalStateException("Cannot reset state before starting call.");
        }
        this.resetState();
        this.started = false;
    }

    void resetState() {
        this.actorStateManager.clear();
    }

    Mono<Void> onActivateInternal() {
        return Mono.fromRunnable(() -> {
            this.actorTrace.writeInfo(TRACE_TYPE, this.id.toString(), "Activating ...", new Object[0]);
            this.resetState();
        }).then(this.onActivate()).then(this.doWriteInfo(TRACE_TYPE, this.id.toString(), "Activated")).then(this.saveState());
    }

    Mono<Void> onDeactivateInternal() {
        this.actorTrace.writeInfo(TRACE_TYPE, this.id.toString(), "Deactivating ...", new Object[0]);
        return Mono.fromRunnable(() -> this.resetState()).then(this.onDeactivate()).then(this.doWriteInfo(TRACE_TYPE, this.id.toString(), "Deactivated"));
    }

    Mono<Void> onPreActorMethodInternal(ActorMethodContext actorMethodContext) {
        return Mono.fromRunnable(() -> {
            if (this.started) {
                throw new IllegalStateException("Cannot invoke a method before completing previous call.");
            }
            this.started = true;
        }).then(this.onPreActorMethod(actorMethodContext));
    }

    Mono<Void> onPostActorMethodInternal(ActorMethodContext actorMethodContext) {
        return Mono.fromRunnable(() -> {
            if (!this.started) {
                throw new IllegalStateException("Cannot complete a method before starting a call.");
            }
        }).then(this.onPostActorMethod(actorMethodContext)).then(this.saveState()).then(Mono.fromRunnable(() -> {
            this.started = false;
        }));
    }

    private Mono<Void> doWriteInfo(String type, String id, String message) {
        return Mono.fromRunnable(() -> this.actorTrace.writeInfo(type, id, message, new Object[0]));
    }
}

