/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorUtils;
import io.dapr.actors.runtime.AbstractActor;
import io.dapr.actors.runtime.ActorTypeUtilities;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

final class ActorTypeInformation<T> {
    private final String name;
    private final Class<T> implementationClass;
    private final Collection<Class<?>> interfaces;
    private final boolean abstractClass;
    private final boolean remindable;

    private ActorTypeInformation(String name, Class<T> implementationClass, Collection<Class<?>> interfaces, boolean abstractClass, boolean remindable) {
        this.name = name;
        this.implementationClass = implementationClass;
        this.interfaces = interfaces;
        this.abstractClass = abstractClass;
        this.remindable = remindable;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    public Collection<Class<?>> getInterfaces() {
        return Collections.unmodifiableCollection(this.interfaces);
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public boolean isRemindable() {
        return this.remindable;
    }

    public static <T> ActorTypeInformation<T> tryCreate(Class<T> actorClass) {
        try {
            return ActorTypeInformation.create(actorClass);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <T> ActorTypeInformation<T> create(Class<T> actorClass) {
        if (!ActorTypeUtilities.isActor(actorClass)) {
            throw new IllegalArgumentException(String.format("The type '%s' is not an Actor. An actor class must inherit from '%s'.", actorClass == null ? "" : actorClass.getCanonicalName(), AbstractActor.class.getCanonicalName()));
        }
        Class<?>[] actorInterfaces = actorClass.getInterfaces();
        boolean isAbstract = Modifier.isAbstract(actorClass.getModifiers());
        boolean isRemindable = ActorTypeUtilities.isRemindableActor(actorClass);
        String typeName = ActorUtils.findActorTypeName(actorClass);
        return new ActorTypeInformation<T>(typeName, actorClass, Arrays.asList(actorInterfaces), isAbstract, isRemindable);
    }
}

