/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorMethod;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ActorMethodInfoMap {
    private final Map<String, Method> methods;

    ActorMethodInfoMap(Collection<Class<?>> interfaceTypes) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Class<?> actorInterface : interfaceTypes) {
            for (Method methodInfo : actorInterface.getMethods()) {
                if (methodInfo.getParameterCount() > 1) continue;
                String methodName = methodInfo.getName();
                ActorMethod actorMethodAnnotation = methodInfo.getAnnotation(ActorMethod.class);
                if (actorMethodAnnotation != null && !actorMethodAnnotation.name().isEmpty()) {
                    methodName = actorMethodAnnotation.name();
                }
                methods.put(methodName, methodInfo);
            }
        }
        this.methods = Collections.unmodifiableMap(methods);
    }

    Method get(String methodName) throws NoSuchMethodException {
        Method method = this.methods.get(methodName);
        if (method == null) {
            throw new NoSuchMethodException(String.format("Could not find method %s.", methodName));
        }
        return method;
    }
}

