/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors;

import java.util.UUID;

public class ActorId
implements Comparable<ActorId> {
    private final String stringId;
    private final String errorMsg = "actor needs to be initialized with an id!";

    public ActorId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("actor needs to be initialized with an id!");
        }
        this.stringId = id;
    }

    public String toString() {
        return this.stringId;
    }

    @Override
    public int compareTo(ActorId other) {
        return other == null ? 1 : this.compareContent(this, other);
    }

    public int hashCode() {
        return this.stringId.hashCode();
    }

    private int compareContent(ActorId id1, ActorId id2) {
        return id1.stringId.compareTo(id2.stringId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ActorId.hasEqualContent(this, (ActorId)obj);
    }

    public static ActorId createRandom() {
        UUID id = UUID.randomUUID();
        return new ActorId(id.toString());
    }

    private static boolean hasEqualContent(ActorId id1, ActorId id2) {
        return id1.stringId.equals(id2.stringId);
    }
}

