/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors;

import io.dapr.actors.ActorType;

public final class ActorUtils {
    public static String findActorTypeName(Class<?> actorClass) {
        Class<?> node;
        if (actorClass == null) {
            throw new IllegalArgumentException("ActorClass is required.");
        }
        for (node = actorClass; node != null && node.getAnnotation(ActorType.class) == null; node = node.getSuperclass()) {
        }
        if (node == null) {
            for (Class<?> interfaze : actorClass.getInterfaces()) {
                if (interfaze.getAnnotation(ActorType.class) == null) continue;
                node = interfaze;
                break;
            }
        }
        if (node == null) {
            return actorClass.getSimpleName();
        }
        ActorType actorTypeAnnotation = node.getAnnotation(ActorType.class);
        return actorTypeAnnotation != null ? actorTypeAnnotation.name() : actorClass.getSimpleName();
    }
}

