/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.client;

import io.dapr.actors.client.DaprClient;
import io.dapr.actors.client.DaprGrpcClient;
import io.dapr.actors.client.DaprHttpClient;
import io.dapr.client.DaprApiProtocol;
import io.dapr.client.DaprHttpBuilder;
import io.dapr.config.Properties;
import io.dapr.utils.Version;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ActorClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActorClient.class);
    private final ManagedChannel grpcManagedChannel;
    private final DaprClient daprClient;

    public ActorClient() {
        this((DaprApiProtocol)Properties.API_PROTOCOL.get());
    }

    private ActorClient(DaprApiProtocol apiProtocol) {
        this(apiProtocol, ActorClient.buildManagedChannel(apiProtocol));
    }

    private ActorClient(DaprApiProtocol apiProtocol, ManagedChannel grpcManagedChannel) {
        this.grpcManagedChannel = grpcManagedChannel;
        this.daprClient = ActorClient.buildDaprClient(apiProtocol, (Channel)grpcManagedChannel);
    }

    Mono<byte[]> invoke(String actorType, String actorId, String methodName, byte[] jsonPayload) {
        return this.daprClient.invoke(actorType, actorId, methodName, jsonPayload);
    }

    @Override
    public void close() {
        if (this.grpcManagedChannel != null && !this.grpcManagedChannel.isShutdown()) {
            this.grpcManagedChannel.shutdown();
        }
    }

    private static ManagedChannel buildManagedChannel(DaprApiProtocol apiProtocol) {
        if (apiProtocol != DaprApiProtocol.GRPC) {
            return null;
        }
        int port = (Integer)Properties.GRPC_PORT.get();
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port.");
        }
        return ManagedChannelBuilder.forAddress((String)((String)Properties.SIDECAR_IP.get()), (int)port).usePlaintext().userAgent(Version.getSdkVersion()).build();
    }

    private static DaprClient buildDaprClient(DaprApiProtocol apiProtocol, Channel grpcManagedChannel) {
        switch (apiProtocol) {
            case GRPC: {
                return new DaprGrpcClient(DaprGrpc.newStub((Channel)grpcManagedChannel));
            }
            case HTTP: {
                LOGGER.warn("HTTP client protocol is deprecated and will be removed in Dapr's Java SDK version 1.10.");
                return new DaprHttpClient(new DaprHttpBuilder().build());
            }
        }
        throw new IllegalStateException("Unsupported protocol: " + apiProtocol.name());
    }
}

