/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import io.dapr.actors.ActorId;
import io.dapr.actors.runtime.AbstractActor;
import io.dapr.actors.runtime.ActorMethodContext;
import io.dapr.actors.runtime.ActorMethodInfoMap;
import io.dapr.actors.runtime.ActorObjectSerializer;
import io.dapr.actors.runtime.ActorReminderParams;
import io.dapr.actors.runtime.ActorRuntimeContext;
import io.dapr.actors.runtime.ActorTimerParams;
import io.dapr.actors.runtime.Remindable;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class ActorManager<T extends AbstractActor> {
    private static final ActorObjectSerializer OBJECT_SERIALIZER = new ActorObjectSerializer();
    private final ActorRuntimeContext<T> runtimeContext;
    private final ActorMethodInfoMap actorMethods;
    private final Map<ActorId, T> activeActors;

    ActorManager(ActorRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.actorMethods = new ActorMethodInfoMap(runtimeContext.getActorTypeInformation().getInterfaces());
        this.activeActors = Collections.synchronizedMap(new HashMap());
    }

    Mono<Void> activateActor(ActorId actorId) {
        return Mono.fromSupplier(() -> {
            if (this.activeActors.containsKey(actorId)) {
                return null;
            }
            return this.runtimeContext.getActorFactory().createActor(this.runtimeContext, actorId);
        }).flatMap(actor -> actor.onActivateInternal().then(this.onActivatedActor(actorId, actor)));
    }

    Mono<Void> deactivateActor(ActorId actorId) {
        return Mono.fromSupplier(() -> (AbstractActor)this.activeActors.remove(actorId)).flatMap(actor -> actor.onDeactivateInternal());
    }

    Mono<Void> invokeReminder(ActorId actorId, String reminderName, byte[] params) {
        return Mono.fromSupplier(() -> {
            if (!this.runtimeContext.getActorTypeInformation().isRemindable()) {
                return null;
            }
            try {
                return OBJECT_SERIALIZER.deserialize(params, ActorReminderParams.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(p -> this.invoke(actorId, ActorMethodContext.createForReminder(reminderName), actor -> this.doReminderInvokation((Remindable)((Object)actor), reminderName, (ActorReminderParams)p))).then();
    }

    Mono<Void> invokeTimer(ActorId actorId, String timerName, byte[] params) {
        return Mono.fromSupplier(() -> {
            try {
                return OBJECT_SERIALIZER.deserialize(params, ActorTimerParams.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(p -> this.invokeMethod(actorId, ActorMethodContext.createForTimer(timerName), p.getCallback(), p.getData())).then();
    }

    private Mono<Void> onActivatedActor(ActorId actorId, T actor) {
        return Mono.fromRunnable(() -> this.activeActors.put(actorId, actor));
    }

    private Mono<Boolean> doReminderInvokation(Remindable actor, String reminderName, ActorReminderParams reminderParams) {
        return Mono.fromSupplier(() -> {
            if (actor == null) {
                throw new IllegalArgumentException("actor is mandatory.");
            }
            if (reminderName == null) {
                throw new IllegalArgumentException("reminderName is mandatory.");
            }
            if (reminderParams == null) {
                throw new IllegalArgumentException("reminderParams is mandatory.");
            }
            return true;
        }).flatMap(x -> {
            try {
                Object data = this.runtimeContext.getObjectSerializer().deserialize(reminderParams.getData(), actor.getStateType());
                return actor.receiveReminder(reminderName, data, reminderParams.getDueTime(), reminderParams.getPeriod());
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).thenReturn((Object)true);
    }

    Mono<byte[]> invokeMethod(ActorId actorId, String methodName, byte[] request) {
        return this.invokeMethod(actorId, null, methodName, request);
    }

    private Mono<byte[]> invokeMethod(ActorId actorId, ActorMethodContext context, String methodName, byte[] request) {
        ActorMethodContext actorMethodContext = context;
        if (actorMethodContext == null) {
            actorMethodContext = ActorMethodContext.createForActor(methodName);
        }
        return this.invoke(actorId, actorMethodContext, actor -> {
            try {
                Method method = this.actorMethods.get(methodName);
                Object input = null;
                if (method.getParameterCount() == 1) {
                    Class<?> inputClass = method.getParameterTypes()[0];
                    input = this.runtimeContext.getObjectSerializer().deserialize(request, TypeRef.get(inputClass));
                }
                if (method.getReturnType().equals(Mono.class)) {
                    return this.invokeMonoMethod((AbstractActor)actor, method, input);
                }
                return this.invokeMethod((AbstractActor)actor, method, input);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).map(r -> {
            try {
                return this.runtimeContext.getObjectSerializer().serialize(r);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Mono<Object> invokeMethod(AbstractActor actor, Method method, Object input) {
        return Mono.fromSupplier(() -> {
            try {
                if (method.getParameterCount() == 0) {
                    return method.invoke((Object)actor, new Object[0]);
                }
                return method.invoke((Object)actor, input);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Mono<Object> invokeMonoMethod(AbstractActor actor, Method method, Object input) {
        try {
            if (method.getParameterCount() == 0) {
                return (Mono)method.invoke((Object)actor, new Object[0]);
            }
            return (Mono)method.invoke((Object)actor, input);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private <T> Mono<T> invoke(ActorId actorId, ActorMethodContext context, Function<AbstractActor, Mono<T>> func) {
        try {
            AbstractActor actor = this.activeActors.getOrDefault(actorId, null);
            if (actor == null) {
                throw new IllegalArgumentException(String.format("Could not find actor %s of type %s.", actorId.toString(), this.runtimeContext.getActorTypeInformation().getName()));
            }
            return actor.onPreActorMethodInternal(context).then(func.apply(actor)).switchIfEmpty(actor.onPostActorMethodInternal(context)).flatMap(r -> actor.onPostActorMethodInternal(context).thenReturn(r)).onErrorMap(throwable -> {
                actor.rollback();
                return throwable;
            }).map(o -> o);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }
}

