/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.actors.runtime;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.dapr.actors.runtime.ActorObjectSerializer;
import io.dapr.actors.runtime.ActorReminderParams;
import io.dapr.actors.runtime.ActorStateOperation;
import io.dapr.actors.runtime.ActorTimerParams;
import io.dapr.actors.runtime.DaprClient;
import io.dapr.client.DaprHttp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import reactor.core.publisher.Mono;

class DaprHttpClient
implements DaprClient {
    private static final ActorObjectSerializer INTERNAL_SERIALIZER = new ActorObjectSerializer();
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final DaprHttp client;

    DaprHttpClient(DaprHttp client) {
        this.client = client;
    }

    @Override
    public Mono<byte[]> getState(String actorType, String actorId, String keyName) {
        String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "state", keyName};
        Mono responseMono = this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, null, "", null, null);
        return responseMono.map(r -> {
            if (r.getStatusCode() != 200 && r.getStatusCode() != 204) {
                throw new IllegalStateException(String.format("Error getting actor state: %s/%s/%s", actorType, actorId, keyName));
            }
            return r.getBody();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Mono<Void> saveStateTransactionally(String actorType, String actorId, List<ActorStateOperation> operations) {
        byte[] payload = null;
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)writer);
            generator.writeStartArray();
            for (ActorStateOperation stateOperation : operations) {
                generator.writeStartObject();
                generator.writeStringField("operation", stateOperation.getOperationType());
                generator.writeObjectFieldStart("request");
                generator.writeStringField("key", stateOperation.getKey());
                Object value = stateOperation.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        generator.writeFieldName("value");
                        generator.writeRawValue((String)value);
                    } else {
                        if (!(value instanceof byte[])) {
                            Mono mono = Mono.error(() -> {
                                throw new IllegalArgumentException("Actor state value must be String or byte[]");
                            });
                            return mono;
                        }
                        generator.writeBinaryField("value", (byte[])value);
                    }
                }
                generator.writeEndObject();
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
            writer.flush();
            payload = writer.toByteArray();
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
        String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "state"};
        return this.client.invokeApi(DaprHttp.HttpMethods.PUT.name(), pathSegments, null, payload, null, null).then();
    }

    @Override
    public Mono<Void> registerReminder(String actorType, String actorId, String reminderName, ActorReminderParams reminderParams) {
        String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "reminders", reminderName};
        return Mono.fromCallable(() -> INTERNAL_SERIALIZER.serialize((Object)reminderParams)).flatMap(data -> this.client.invokeApi(DaprHttp.HttpMethods.PUT.name(), pathSegments, null, data, null, null)).then();
    }

    @Override
    public Mono<Void> unregisterReminder(String actorType, String actorId, String reminderName) {
        String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "reminders", reminderName};
        return this.client.invokeApi(DaprHttp.HttpMethods.DELETE.name(), pathSegments, null, null, null).then();
    }

    @Override
    public Mono<Void> registerTimer(String actorType, String actorId, String timerName, ActorTimerParams timerParams) {
        return Mono.fromCallable(() -> INTERNAL_SERIALIZER.serialize((Object)timerParams)).flatMap(data -> {
            String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "timers", timerName};
            return this.client.invokeApi(DaprHttp.HttpMethods.PUT.name(), pathSegments, null, data, null, null);
        }).then();
    }

    @Override
    public Mono<Void> unregisterTimer(String actorType, String actorId, String timerName) {
        String[] pathSegments = new String[]{"v1.0", "actors", actorType, actorId, "timers", timerName};
        return this.client.invokeApi(DaprHttp.HttpMethods.DELETE.name(), pathSegments, null, null, null).then();
    }
}

