package io.dapr.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * AppCallback V1 allows user application to interact with Dapr runtime.
 * User application needs to implement AppCallback service if it needs to
 * receive message from dapr runtime.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.59.0)",
    comments = "Source: appcallback.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class AppCallbackGrpc {

  private AppCallbackGrpc() {}

  public static final java.lang.String SERVICE_NAME = "dapr.proto.runtime.v1.AppCallback";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.dapr.v1.CommonProtos.InvokeRequest,
      io.dapr.v1.CommonProtos.InvokeResponse> getOnInvokeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnInvoke",
      requestType = io.dapr.v1.CommonProtos.InvokeRequest.class,
      responseType = io.dapr.v1.CommonProtos.InvokeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.dapr.v1.CommonProtos.InvokeRequest,
      io.dapr.v1.CommonProtos.InvokeResponse> getOnInvokeMethod() {
    io.grpc.MethodDescriptor<io.dapr.v1.CommonProtos.InvokeRequest, io.dapr.v1.CommonProtos.InvokeResponse> getOnInvokeMethod;
    if ((getOnInvokeMethod = AppCallbackGrpc.getOnInvokeMethod) == null) {
      synchronized (AppCallbackGrpc.class) {
        if ((getOnInvokeMethod = AppCallbackGrpc.getOnInvokeMethod) == null) {
          AppCallbackGrpc.getOnInvokeMethod = getOnInvokeMethod =
              io.grpc.MethodDescriptor.<io.dapr.v1.CommonProtos.InvokeRequest, io.dapr.v1.CommonProtos.InvokeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnInvoke"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.CommonProtos.InvokeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.CommonProtos.InvokeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new AppCallbackMethodDescriptorSupplier("OnInvoke"))
              .build();
        }
      }
    }
    return getOnInvokeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> getListTopicSubscriptionsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListTopicSubscriptions",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> getListTopicSubscriptionsMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> getListTopicSubscriptionsMethod;
    if ((getListTopicSubscriptionsMethod = AppCallbackGrpc.getListTopicSubscriptionsMethod) == null) {
      synchronized (AppCallbackGrpc.class) {
        if ((getListTopicSubscriptionsMethod = AppCallbackGrpc.getListTopicSubscriptionsMethod) == null) {
          AppCallbackGrpc.getListTopicSubscriptionsMethod = getListTopicSubscriptionsMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListTopicSubscriptions"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new AppCallbackMethodDescriptorSupplier("ListTopicSubscriptions"))
              .build();
        }
      }
    }
    return getListTopicSubscriptionsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest,
      io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> getOnTopicEventMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnTopicEvent",
      requestType = io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest.class,
      responseType = io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest,
      io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> getOnTopicEventMethod() {
    io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest, io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> getOnTopicEventMethod;
    if ((getOnTopicEventMethod = AppCallbackGrpc.getOnTopicEventMethod) == null) {
      synchronized (AppCallbackGrpc.class) {
        if ((getOnTopicEventMethod = AppCallbackGrpc.getOnTopicEventMethod) == null) {
          AppCallbackGrpc.getOnTopicEventMethod = getOnTopicEventMethod =
              io.grpc.MethodDescriptor.<io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest, io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnTopicEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse.getDefaultInstance()))
              .setSchemaDescriptor(new AppCallbackMethodDescriptorSupplier("OnTopicEvent"))
              .build();
        }
      }
    }
    return getOnTopicEventMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> getListInputBindingsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListInputBindings",
      requestType = com.google.protobuf.Empty.class,
      responseType = io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.google.protobuf.Empty,
      io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> getListInputBindingsMethod() {
    io.grpc.MethodDescriptor<com.google.protobuf.Empty, io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> getListInputBindingsMethod;
    if ((getListInputBindingsMethod = AppCallbackGrpc.getListInputBindingsMethod) == null) {
      synchronized (AppCallbackGrpc.class) {
        if ((getListInputBindingsMethod = AppCallbackGrpc.getListInputBindingsMethod) == null) {
          AppCallbackGrpc.getListInputBindingsMethod = getListInputBindingsMethod =
              io.grpc.MethodDescriptor.<com.google.protobuf.Empty, io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListInputBindings"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new AppCallbackMethodDescriptorSupplier("ListInputBindings"))
              .build();
        }
      }
    }
    return getListInputBindingsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest,
      io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> getOnBindingEventMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OnBindingEvent",
      requestType = io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest.class,
      responseType = io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest,
      io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> getOnBindingEventMethod() {
    io.grpc.MethodDescriptor<io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest, io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> getOnBindingEventMethod;
    if ((getOnBindingEventMethod = AppCallbackGrpc.getOnBindingEventMethod) == null) {
      synchronized (AppCallbackGrpc.class) {
        if ((getOnBindingEventMethod = AppCallbackGrpc.getOnBindingEventMethod) == null) {
          AppCallbackGrpc.getOnBindingEventMethod = getOnBindingEventMethod =
              io.grpc.MethodDescriptor.<io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest, io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OnBindingEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse.getDefaultInstance()))
              .setSchemaDescriptor(new AppCallbackMethodDescriptorSupplier("OnBindingEvent"))
              .build();
        }
      }
    }
    return getOnBindingEventMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static AppCallbackStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AppCallbackStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AppCallbackStub>() {
        @java.lang.Override
        public AppCallbackStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AppCallbackStub(channel, callOptions);
        }
      };
    return AppCallbackStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static AppCallbackBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AppCallbackBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AppCallbackBlockingStub>() {
        @java.lang.Override
        public AppCallbackBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AppCallbackBlockingStub(channel, callOptions);
        }
      };
    return AppCallbackBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static AppCallbackFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<AppCallbackFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<AppCallbackFutureStub>() {
        @java.lang.Override
        public AppCallbackFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new AppCallbackFutureStub(channel, callOptions);
        }
      };
    return AppCallbackFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * AppCallback V1 allows user application to interact with Dapr runtime.
   * User application needs to implement AppCallback service if it needs to
   * receive message from dapr runtime.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * Invokes service method with InvokeRequest.
     * </pre>
     */
    default void onInvoke(io.dapr.v1.CommonProtos.InvokeRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.CommonProtos.InvokeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnInvokeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lists all topics subscribed by this app.
     * </pre>
     */
    default void listTopicSubscriptions(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListTopicSubscriptionsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Subscribes events from Pubsub
     * </pre>
     */
    default void onTopicEvent(io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnTopicEventMethod(), responseObserver);
    }

    /**
     * <pre>
     * Lists all input bindings subscribed by this app.
     * </pre>
     */
    default void listInputBindings(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListInputBindingsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Listens events from the input bindings
     * User application can save the states or send the events to the output
     * bindings optionally by returning BindingEventResponse.
     * </pre>
     */
    default void onBindingEvent(io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOnBindingEventMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service AppCallback.
   * <pre>
   * AppCallback V1 allows user application to interact with Dapr runtime.
   * User application needs to implement AppCallback service if it needs to
   * receive message from dapr runtime.
   * </pre>
   */
  public static abstract class AppCallbackImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return AppCallbackGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service AppCallback.
   * <pre>
   * AppCallback V1 allows user application to interact with Dapr runtime.
   * User application needs to implement AppCallback service if it needs to
   * receive message from dapr runtime.
   * </pre>
   */
  public static final class AppCallbackStub
      extends io.grpc.stub.AbstractAsyncStub<AppCallbackStub> {
    private AppCallbackStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AppCallbackStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AppCallbackStub(channel, callOptions);
    }

    /**
     * <pre>
     * Invokes service method with InvokeRequest.
     * </pre>
     */
    public void onInvoke(io.dapr.v1.CommonProtos.InvokeRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.CommonProtos.InvokeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnInvokeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lists all topics subscribed by this app.
     * </pre>
     */
    public void listTopicSubscriptions(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListTopicSubscriptionsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Subscribes events from Pubsub
     * </pre>
     */
    public void onTopicEvent(io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnTopicEventMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Lists all input bindings subscribed by this app.
     * </pre>
     */
    public void listInputBindings(com.google.protobuf.Empty request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListInputBindingsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Listens events from the input bindings
     * User application can save the states or send the events to the output
     * bindings optionally by returning BindingEventResponse.
     * </pre>
     */
    public void onBindingEvent(io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest request,
        io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getOnBindingEventMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service AppCallback.
   * <pre>
   * AppCallback V1 allows user application to interact with Dapr runtime.
   * User application needs to implement AppCallback service if it needs to
   * receive message from dapr runtime.
   * </pre>
   */
  public static final class AppCallbackBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<AppCallbackBlockingStub> {
    private AppCallbackBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AppCallbackBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AppCallbackBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Invokes service method with InvokeRequest.
     * </pre>
     */
    public io.dapr.v1.CommonProtos.InvokeResponse onInvoke(io.dapr.v1.CommonProtos.InvokeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnInvokeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lists all topics subscribed by this app.
     * </pre>
     */
    public io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse listTopicSubscriptions(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListTopicSubscriptionsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Subscribes events from Pubsub
     * </pre>
     */
    public io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse onTopicEvent(io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnTopicEventMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Lists all input bindings subscribed by this app.
     * </pre>
     */
    public io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse listInputBindings(com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListInputBindingsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Listens events from the input bindings
     * User application can save the states or send the events to the output
     * bindings optionally by returning BindingEventResponse.
     * </pre>
     */
    public io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse onBindingEvent(io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getOnBindingEventMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service AppCallback.
   * <pre>
   * AppCallback V1 allows user application to interact with Dapr runtime.
   * User application needs to implement AppCallback service if it needs to
   * receive message from dapr runtime.
   * </pre>
   */
  public static final class AppCallbackFutureStub
      extends io.grpc.stub.AbstractFutureStub<AppCallbackFutureStub> {
    private AppCallbackFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected AppCallbackFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new AppCallbackFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Invokes service method with InvokeRequest.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.dapr.v1.CommonProtos.InvokeResponse> onInvoke(
        io.dapr.v1.CommonProtos.InvokeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnInvokeMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Lists all topics subscribed by this app.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse> listTopicSubscriptions(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListTopicSubscriptionsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Subscribes events from Pubsub
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse> onTopicEvent(
        io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnTopicEventMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Lists all input bindings subscribed by this app.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse> listInputBindings(
        com.google.protobuf.Empty request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListInputBindingsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Listens events from the input bindings
     * User application can save the states or send the events to the output
     * bindings optionally by returning BindingEventResponse.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse> onBindingEvent(
        io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getOnBindingEventMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ON_INVOKE = 0;
  private static final int METHODID_LIST_TOPIC_SUBSCRIPTIONS = 1;
  private static final int METHODID_ON_TOPIC_EVENT = 2;
  private static final int METHODID_LIST_INPUT_BINDINGS = 3;
  private static final int METHODID_ON_BINDING_EVENT = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ON_INVOKE:
          serviceImpl.onInvoke((io.dapr.v1.CommonProtos.InvokeRequest) request,
              (io.grpc.stub.StreamObserver<io.dapr.v1.CommonProtos.InvokeResponse>) responseObserver);
          break;
        case METHODID_LIST_TOPIC_SUBSCRIPTIONS:
          serviceImpl.listTopicSubscriptions((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse>) responseObserver);
          break;
        case METHODID_ON_TOPIC_EVENT:
          serviceImpl.onTopicEvent((io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest) request,
              (io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse>) responseObserver);
          break;
        case METHODID_LIST_INPUT_BINDINGS:
          serviceImpl.listInputBindings((com.google.protobuf.Empty) request,
              (io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse>) responseObserver);
          break;
        case METHODID_ON_BINDING_EVENT:
          serviceImpl.onBindingEvent((io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest) request,
              (io.grpc.stub.StreamObserver<io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getOnInvokeMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.dapr.v1.CommonProtos.InvokeRequest,
              io.dapr.v1.CommonProtos.InvokeResponse>(
                service, METHODID_ON_INVOKE)))
        .addMethod(
          getListTopicSubscriptionsMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.google.protobuf.Empty,
              io.dapr.v1.DaprAppCallbackProtos.ListTopicSubscriptionsResponse>(
                service, METHODID_LIST_TOPIC_SUBSCRIPTIONS)))
        .addMethod(
          getOnTopicEventMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.dapr.v1.DaprAppCallbackProtos.TopicEventRequest,
              io.dapr.v1.DaprAppCallbackProtos.TopicEventResponse>(
                service, METHODID_ON_TOPIC_EVENT)))
        .addMethod(
          getListInputBindingsMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.google.protobuf.Empty,
              io.dapr.v1.DaprAppCallbackProtos.ListInputBindingsResponse>(
                service, METHODID_LIST_INPUT_BINDINGS)))
        .addMethod(
          getOnBindingEventMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.dapr.v1.DaprAppCallbackProtos.BindingEventRequest,
              io.dapr.v1.DaprAppCallbackProtos.BindingEventResponse>(
                service, METHODID_ON_BINDING_EVENT)))
        .build();
  }

  private static abstract class AppCallbackBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    AppCallbackBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.dapr.v1.DaprAppCallbackProtos.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("AppCallback");
    }
  }

  private static final class AppCallbackFileDescriptorSupplier
      extends AppCallbackBaseDescriptorSupplier {
    AppCallbackFileDescriptorSupplier() {}
  }

  private static final class AppCallbackMethodDescriptorSupplier
      extends AppCallbackBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final java.lang.String methodName;

    AppCallbackMethodDescriptorSupplier(java.lang.String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (AppCallbackGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new AppCallbackFileDescriptorSupplier())
              .addMethod(getOnInvokeMethod())
              .addMethod(getListTopicSubscriptionsMethod())
              .addMethod(getOnTopicEventMethod())
              .addMethod(getListInputBindingsMethod())
              .addMethod(getOnBindingEventMethod())
              .build();
        }
      }
    }
    return result;
  }
}
