/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.springboot;

import io.dapr.springboot.DaprSubscriptionBuilder;
import io.dapr.springboot.DaprTopicBulkSubscribe;
import io.dapr.springboot.DaprTopicKey;
import io.dapr.springboot.DaprTopicSubscription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class DaprRuntime {
    private static volatile DaprRuntime instance;
    private final Map<DaprTopicKey, DaprSubscriptionBuilder> subscriptionBuilders = new HashMap<DaprTopicKey, DaprSubscriptionBuilder>();

    private DaprRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DaprRuntime getInstance() {
        if (instance != null) return instance;
        Class<DaprRuntime> clazz = DaprRuntime.class;
        synchronized (DaprRuntime.class) {
            if (instance != null) return instance;
            instance = new DaprRuntime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void addSubscribedTopic(String pubSubName, String topicName, String match, int priority, String route, Map<String, String> metadata) {
        this.addSubscribedTopic(pubSubName, topicName, match, priority, route, metadata, null);
    }

    public synchronized void addSubscribedTopic(String pubSubName, String topicName, String match, int priority, String route, Map<String, String> metadata, DaprTopicBulkSubscribe bulkSubscribe) {
        this.addSubscribedTopic(pubSubName, topicName, match, priority, route, null, metadata, bulkSubscribe);
    }

    public synchronized void addSubscribedTopic(String pubSubName, String topicName, String match, int priority, String route, String deadLetterTopic, Map<String, String> metadata) {
        this.addSubscribedTopic(pubSubName, topicName, match, priority, route, deadLetterTopic, metadata, null);
    }

    public synchronized void addSubscribedTopic(String pubSubName, String topicName, String match, int priority, String route, String deadLetterTopic, Map<String, String> metadata, DaprTopicBulkSubscribe bulkSubscribe) {
        DaprTopicKey topicKey = new DaprTopicKey(pubSubName, topicName);
        DaprSubscriptionBuilder builder = this.subscriptionBuilders.get(topicKey);
        if (builder == null) {
            builder = new DaprSubscriptionBuilder(pubSubName, topicName);
            this.subscriptionBuilders.put(topicKey, builder);
        }
        if (match.length() > 0) {
            builder.addRule(route, match, priority);
        } else {
            builder.setDefaultPath(route);
        }
        if (metadata != null && !metadata.isEmpty()) {
            builder.setMetadata(metadata);
        }
        if (deadLetterTopic != null && !deadLetterTopic.isEmpty()) {
            builder.setDeadLetterTopic(deadLetterTopic);
        }
        if (bulkSubscribe != null) {
            builder.setBulkSubscribe(bulkSubscribe);
        }
    }

    public synchronized DaprTopicSubscription[] listSubscribedTopics() {
        List<DaprTopicSubscription> values = this.subscriptionBuilders.values().stream().map(b -> b.build()).collect(Collectors.toList());
        return values.toArray(new DaprTopicSubscription[0]);
    }
}

