/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.springboot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.Rule;
import io.dapr.Topic;
import io.dapr.springboot.DaprRuntime;
import io.dapr.springboot.DaprTopicBulkSubscribe;
import io.dapr.springboot.annotations.BulkSubscribe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class DaprBeanPostProcessor
implements BeanPostProcessor {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final EmbeddedValueResolver embeddedValueResolver;

    DaprBeanPostProcessor(ConfigurableBeanFactory beanFactory) {
        this.embeddedValueResolver = new EmbeddedValueResolver(beanFactory);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return null;
        }
        DaprBeanPostProcessor.subscribeToTopics(bean.getClass(), (StringValueResolver)this.embeddedValueResolver, DaprRuntime.getInstance());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static void subscribeToTopics(Class clazz, StringValueResolver stringValueResolver, DaprRuntime daprRuntime) {
        if (clazz == null) {
            return;
        }
        DaprBeanPostProcessor.subscribeToTopics(clazz.getSuperclass(), stringValueResolver, daprRuntime);
        for (Method method : clazz.getDeclaredMethods()) {
            Topic topic = method.getAnnotation(Topic.class);
            if (topic == null) continue;
            DaprTopicBulkSubscribe bulkSubscribe = null;
            BulkSubscribe bulkSubscribeAnnotation = method.getAnnotation(BulkSubscribe.class);
            if (bulkSubscribeAnnotation != null) {
                int maxAwaitDurationMs;
                bulkSubscribe = new DaprTopicBulkSubscribe(true);
                int maxMessagesCount = bulkSubscribeAnnotation.maxMessagesCount();
                if (maxMessagesCount != -1) {
                    bulkSubscribe.setMaxMessagesCount(maxMessagesCount);
                }
                if ((maxAwaitDurationMs = bulkSubscribeAnnotation.maxAwaitDurationMs()) != -1) {
                    bulkSubscribe.setMaxAwaitDurationMs(maxAwaitDurationMs);
                }
            }
            Rule rule = topic.rule();
            String topicName = stringValueResolver.resolveStringValue(topic.name());
            String pubSubName = stringValueResolver.resolveStringValue(topic.pubsubName());
            String match = stringValueResolver.resolveStringValue(rule.match());
            if (topicName == null || topicName.length() <= 0 || pubSubName == null || pubSubName.length() <= 0) continue;
            try {
                TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                Map metadata = (Map)MAPPER.readValue(topic.metadata(), (TypeReference)typeRef);
                List<String> routes = DaprBeanPostProcessor.getAllCompleteRoutesForPost(clazz, method, topicName);
                for (String route : routes) {
                    daprRuntime.addSubscribedTopic(pubSubName, topicName, match, rule.priority(), route, metadata, bulkSubscribe);
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Error while parsing metadata: " + (Object)((Object)e));
            }
        }
    }

    private static List<String> getAllCompleteRoutesForPost(Class clazz, Method method, String topicName) {
        String[] postValueArray;
        ArrayList<String> routesList = new ArrayList<String>();
        RequestMapping clazzRequestMapping = clazz.getAnnotation(RequestMapping.class);
        String[] clazzLevelRoute = null;
        if (clazzRequestMapping != null) {
            clazzLevelRoute = clazzRequestMapping.value();
        }
        if ((postValueArray = DaprBeanPostProcessor.getRoutesForPost(method, topicName)) != null && postValueArray.length >= 1) {
            for (String postValue : postValueArray) {
                if (clazzLevelRoute != null && clazzLevelRoute.length >= 1) {
                    for (String clazzLevelValue : clazzLevelRoute) {
                        String route = clazzLevelValue + DaprBeanPostProcessor.confirmLeadingSlash(postValue);
                        routesList.add(route);
                    }
                    continue;
                }
                routesList.add(postValue);
            }
        }
        return routesList;
    }

    private static String[] getRoutesForPost(Method method, String topicName) {
        String[] postValueArray;
        block4: {
            block2: {
                PostMapping postMapping;
                block3: {
                    postValueArray = new String[]{topicName};
                    postMapping = method.getAnnotation(PostMapping.class);
                    if (postMapping == null) break block2;
                    if (postMapping.path() == null || postMapping.path().length < 1) break block3;
                    postValueArray = postMapping.path();
                    break block4;
                }
                if (postMapping.value() == null || postMapping.value().length < 1) break block4;
                postValueArray = postMapping.value();
                break block4;
            }
            RequestMapping reqMapping = method.getAnnotation(RequestMapping.class);
            for (RequestMethod reqMethod : reqMapping.method()) {
                if (reqMethod != RequestMethod.POST) continue;
                if (reqMapping.path() != null && reqMapping.path().length >= 1) {
                    postValueArray = reqMapping.path();
                    break;
                }
                if (reqMapping.value() == null || reqMapping.value().length < 1) break;
                postValueArray = reqMapping.value();
                break;
            }
        }
        return postValueArray;
    }

    private static String confirmLeadingSlash(String path) {
        if (path != null && path.length() >= 1 && !path.substring(0, 1).equals("/")) {
            return "/" + path;
        }
        return path;
    }
}

