/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.springboot;

import io.dapr.actors.runtime.ActorRuntime;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.springboot.DaprRuntime;
import java.io.IOException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class DaprController {
    private static final DefaultObjectSerializer SERIALIZER = new DefaultObjectSerializer();

    @GetMapping(path={"/healthz"})
    public void healthz() {
    }

    @GetMapping(path={"/dapr/config"}, produces={"application/json"})
    public byte[] daprConfig() throws IOException {
        return ActorRuntime.getInstance().serializeConfig();
    }

    @GetMapping(path={"/dapr/subscribe"}, produces={"application/json"})
    public byte[] daprSubscribe() throws IOException {
        return SERIALIZER.serialize((Object)DaprRuntime.getInstance().listSubscribedTopics());
    }

    @DeleteMapping(path={"/actors/{type}/{id}"})
    public Mono<Void> deactivateActor(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        return ActorRuntime.getInstance().deactivate(type, id);
    }

    @PutMapping(path={"/actors/{type}/{id}/method/{method}"})
    public Mono<byte[]> invokeActorMethod(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="method") String method, @RequestBody(required=false) byte[] body) {
        return ActorRuntime.getInstance().invoke(type, id, method, body);
    }

    @PutMapping(path={"/actors/{type}/{id}/method/timer/{timer}"})
    public Mono<Void> invokeActorTimer(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="timer") String timer, @RequestBody byte[] body) {
        return ActorRuntime.getInstance().invokeTimer(type, id, timer, body);
    }

    @PutMapping(path={"/actors/{type}/{id}/method/remind/{reminder}"})
    public Mono<Void> invokeActorReminder(@PathVariable(value="type") String type, @PathVariable(value="id") String id, @PathVariable(value="reminder") String reminder, @RequestBody(required=false) byte[] body) {
        return ActorRuntime.getInstance().invokeReminder(type, id, reminder, body);
    }
}

