/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.springboot;

import io.dapr.springboot.DaprTopicBulkSubscribe;
import io.dapr.springboot.DaprTopicRoutes;
import io.dapr.springboot.DaprTopicRule;
import io.dapr.springboot.DaprTopicSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class DaprSubscriptionBuilder {
    private final String pubsubName;
    private final String topic;
    private final List<TopicRule> rules;
    private String defaultPath;
    private Map<String, String> metadata;
    private DaprTopicBulkSubscribe bulkSubscribe;

    DaprSubscriptionBuilder(String pubsubName, String topic) {
        this.pubsubName = pubsubName;
        this.topic = topic;
        this.rules = new ArrayList<TopicRule>();
        this.defaultPath = null;
        this.metadata = Collections.emptyMap();
    }

    DaprSubscriptionBuilder setDefaultPath(String path) {
        if (this.defaultPath != null && !this.defaultPath.equals(path)) {
            throw new RuntimeException(String.format("a default route is already set for topic %s on pubsub %s (current: '%s', supplied: '%s')", this.topic, this.pubsubName, this.defaultPath, path));
        }
        this.defaultPath = path;
        return this;
    }

    public DaprSubscriptionBuilder addRule(String path, String match, int priority) {
        if (this.rules.stream().anyMatch(e -> e.getPriority() == priority)) {
            throw new RuntimeException(String.format("a rule priority of %d is already used for topic %s on pubsub %s", priority, this.topic, this.pubsubName));
        }
        this.rules.add(new TopicRule(path, match, priority));
        return this;
    }

    public DaprSubscriptionBuilder setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DaprSubscriptionBuilder setBulkSubscribe(DaprTopicBulkSubscribe bulkSubscribe) {
        this.bulkSubscribe = bulkSubscribe;
        return this;
    }

    public DaprTopicSubscription build() {
        String route = null;
        DaprTopicRoutes routes = null;
        if (!this.rules.isEmpty()) {
            Collections.sort(this.rules, Comparator.comparingInt(TopicRule::getPriority));
            List<DaprTopicRule> topicRules = this.rules.stream().map(e -> new DaprTopicRule(((TopicRule)e).match, ((TopicRule)e).path)).collect(Collectors.toList());
            routes = new DaprTopicRoutes(topicRules, this.defaultPath);
        } else {
            route = this.defaultPath;
        }
        return new DaprTopicSubscription(this.pubsubName, this.topic, route, routes, this.metadata, this.bulkSubscribe);
    }

    private static class TopicRule {
        private final String path;
        private final String match;
        private final int priority;

        public TopicRule(String path, String match, int priority) {
            this.path = path;
            this.match = match;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

