/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import com.microsoft.durabletask.TaskActivity;
import com.microsoft.durabletask.TaskActivityFactory;
import io.dapr.workflows.runtime.WorkflowActivity;
import io.dapr.workflows.runtime.WorkflowActivityContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ActivityWrapper<T extends WorkflowActivity>
implements TaskActivityFactory {
    private final Constructor<T> activityConstructor;
    private final String name;

    public ActivityWrapper(Class<T> clazz) {
        this.name = clazz.getCanonicalName();
        try {
            this.activityConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("No constructor found for activity class '%s'.", this.name), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public TaskActivity create() {
        return ctx -> {
            WorkflowActivity activity;
            try {
                activity = (WorkflowActivity)this.activityConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Unable to instantiate instance of activity class '%s'", this.name), e);
            }
            Object result = activity.run(new WorkflowActivityContext(ctx));
            return result;
        };
    }
}

