/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import com.microsoft.durabletask.OrchestrationRuntimeStatus;
import java.util.List;
import java.util.stream.Collectors;

public enum WorkflowRuntimeStatus {
    RUNNING,
    COMPLETED,
    CONTINUED_AS_NEW,
    FAILED,
    CANCELED,
    TERMINATED,
    PENDING,
    SUSPENDED;


    public static WorkflowRuntimeStatus fromOrchestrationRuntimeStatus(OrchestrationRuntimeStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        switch (status) {
            case RUNNING: {
                return RUNNING;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case CONTINUED_AS_NEW: {
                return CONTINUED_AS_NEW;
            }
            case FAILED: {
                return FAILED;
            }
            case CANCELED: {
                return CANCELED;
            }
            case TERMINATED: {
                return TERMINATED;
            }
            case PENDING: {
                return PENDING;
            }
            case SUSPENDED: {
                return SUSPENDED;
            }
        }
        throw new RuntimeException(String.format("Unknown status value: %s", status));
    }

    public static OrchestrationRuntimeStatus toOrchestrationRuntimeStatus(WorkflowRuntimeStatus status) {
        switch (status) {
            case RUNNING: {
                return OrchestrationRuntimeStatus.RUNNING;
            }
            case COMPLETED: {
                return OrchestrationRuntimeStatus.COMPLETED;
            }
            case CONTINUED_AS_NEW: {
                return OrchestrationRuntimeStatus.CONTINUED_AS_NEW;
            }
            case FAILED: {
                return OrchestrationRuntimeStatus.FAILED;
            }
            case CANCELED: {
                return OrchestrationRuntimeStatus.CANCELED;
            }
            case TERMINATED: {
                return OrchestrationRuntimeStatus.TERMINATED;
            }
            case PENDING: {
                return OrchestrationRuntimeStatus.PENDING;
            }
            case SUSPENDED: {
                return OrchestrationRuntimeStatus.SUSPENDED;
            }
        }
        throw new RuntimeException(String.format("Unknown status value: %s", new Object[]{status}));
    }

    public static List<OrchestrationRuntimeStatus> toOrchestrationRuntimeStatus(List<WorkflowRuntimeStatus> statuses) {
        return statuses.stream().map(x -> WorkflowRuntimeStatus.toOrchestrationRuntimeStatus(x)).collect(Collectors.toList());
    }
}

