/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows;

import com.microsoft.durabletask.CompositeTaskFailedException;
import com.microsoft.durabletask.Task;
import com.microsoft.durabletask.TaskCanceledException;
import com.microsoft.durabletask.TaskOptions;
import com.microsoft.durabletask.TaskOrchestrationContext;
import io.dapr.workflows.WorkflowContext;
import io.dapr.workflows.saga.DaprSagaContextImpl;
import io.dapr.workflows.saga.Saga;
import io.dapr.workflows.saga.SagaContext;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class DaprWorkflowContextImpl
implements WorkflowContext {
    private final TaskOrchestrationContext innerContext;
    private final Logger logger;
    private final Saga saga;

    public DaprWorkflowContextImpl(TaskOrchestrationContext context) throws IllegalArgumentException {
        this(context, LoggerFactory.getLogger(WorkflowContext.class));
    }

    public DaprWorkflowContextImpl(TaskOrchestrationContext context, Logger logger) throws IllegalArgumentException {
        this(context, logger, null);
    }

    public DaprWorkflowContextImpl(TaskOrchestrationContext context, Saga saga) throws IllegalArgumentException {
        this(context, LoggerFactory.getLogger(WorkflowContext.class), saga);
    }

    public DaprWorkflowContextImpl(TaskOrchestrationContext context, Logger logger, Saga saga) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        this.innerContext = context;
        this.logger = logger;
        this.saga = saga;
    }

    @Override
    public Logger getLogger() {
        if (this.innerContext.getIsReplaying()) {
            return NOPLogger.NOP_LOGGER;
        }
        return this.logger;
    }

    @Override
    public String getName() {
        return this.innerContext.getName();
    }

    @Override
    public String getInstanceId() {
        return this.innerContext.getInstanceId();
    }

    @Override
    public Instant getCurrentInstant() {
        return this.innerContext.getCurrentInstant();
    }

    @Override
    public void complete(Object output) {
        this.innerContext.complete(output);
    }

    @Override
    public <V> Task<V> waitForExternalEvent(String name, Duration timeout, Class<V> dataType) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, timeout, dataType);
    }

    @Override
    public <V> Task<Void> waitForExternalEvent(String name, Duration timeout) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, timeout, Void.class);
    }

    @Override
    public <V> Task<Void> waitForExternalEvent(String name) throws TaskCanceledException {
        return this.innerContext.waitForExternalEvent(name, null, Void.class);
    }

    @Override
    public boolean isReplaying() {
        return this.innerContext.getIsReplaying();
    }

    @Override
    public <V> Task<V> callActivity(String name, Object input, TaskOptions options, Class<V> returnType) {
        return this.innerContext.callActivity(name, input, options, returnType);
    }

    @Override
    public <V> Task<List<V>> allOf(List<Task<V>> tasks) throws CompositeTaskFailedException {
        return this.innerContext.allOf(tasks);
    }

    @Override
    public Task<Task<?>> anyOf(List<Task<?>> tasks) {
        return this.innerContext.anyOf(tasks);
    }

    @Override
    public Task<Void> createTimer(Duration duration) {
        return this.innerContext.createTimer(duration);
    }

    public <T> T getInput(Class<T> targetType) {
        return (T)this.innerContext.getInput(targetType);
    }

    @Override
    public <V> Task<V> callSubWorkflow(String name, @Nullable Object input, @Nullable String instanceID, @Nullable TaskOptions options, Class<V> returnType) {
        return this.innerContext.callSubOrchestrator(name, input, instanceID, options, returnType);
    }

    @Override
    public void continueAsNew(Object input) {
        this.innerContext.continueAsNew(input);
    }

    @Override
    public void continueAsNew(Object input, boolean preserveUnprocessedEvents) {
        this.innerContext.continueAsNew(input, preserveUnprocessedEvents);
    }

    @Override
    public UUID newUuid() {
        return this.innerContext.newUUID();
    }

    @Override
    public SagaContext getSagaContext() {
        if (this.saga == null) {
            throw new UnsupportedOperationException("Saga is not enabled");
        }
        return new DaprSagaContextImpl(this.saga, this);
    }
}

