/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows;

import com.microsoft.durabletask.interruption.ContinueAsNewInterruption;
import com.microsoft.durabletask.interruption.OrchestratorBlockedException;
import io.dapr.workflows.WorkflowContext;
import io.dapr.workflows.WorkflowStub;
import io.dapr.workflows.saga.SagaCompensationException;
import io.dapr.workflows.saga.SagaOption;

public abstract class Workflow {
    public abstract WorkflowStub create();

    public void run(WorkflowContext ctx) {
        WorkflowStub stub = this.create();
        if (!this.isSagaEnabled()) {
            stub.run(ctx);
        } else {
            try {
                stub.run(ctx);
            }
            catch (ContinueAsNewInterruption | OrchestratorBlockedException e) {
                throw e;
            }
            catch (SagaCompensationException e) {
                throw e;
            }
            catch (Exception e) {
                try {
                    ctx.getSagaContext().compensate();
                }
                catch (Exception se) {
                    se.addSuppressed(e);
                    throw se;
                }
                throw e;
            }
        }
    }

    public boolean isSagaEnabled() {
        return this.getSagaOption() != null;
    }

    public SagaOption getSagaOption() {
        return null;
    }
}

