/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.client;

import com.microsoft.durabletask.DurableTaskClient;
import com.microsoft.durabletask.DurableTaskGrpcClientBuilder;
import com.microsoft.durabletask.OrchestrationMetadata;
import com.microsoft.durabletask.PurgeResult;
import io.dapr.utils.NetworkUtils;
import io.dapr.workflows.Workflow;
import io.dapr.workflows.client.NewWorkflowOption;
import io.dapr.workflows.client.WorkflowInstanceStatus;
import io.dapr.workflows.internal.ApiTokenClientInterceptor;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class DaprWorkflowClient
implements AutoCloseable {
    private DurableTaskClient innerClient;
    private ManagedChannel grpcChannel;
    private static ClientInterceptor WORKFLOW_INTERCEPTOR = new ApiTokenClientInterceptor();

    public DaprWorkflowClient() {
        this(NetworkUtils.buildGrpcManagedChannel((ClientInterceptor[])new ClientInterceptor[]{WORKFLOW_INTERCEPTOR}));
    }

    private DaprWorkflowClient(ManagedChannel grpcChannel) {
        this(DaprWorkflowClient.createDurableTaskClient(grpcChannel), grpcChannel);
    }

    private DaprWorkflowClient(DurableTaskClient innerClient, ManagedChannel grpcChannel) {
        this.innerClient = innerClient;
        this.grpcChannel = grpcChannel;
    }

    private static DurableTaskClient createDurableTaskClient(ManagedChannel grpcChannel) {
        return new DurableTaskGrpcClientBuilder().grpcChannel((Channel)grpcChannel).build();
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName());
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, Object input) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), input);
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, Object input, String instanceId) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), input, instanceId);
    }

    public <T extends Workflow> String scheduleNewWorkflow(Class<T> clazz, NewWorkflowOption options) {
        return this.innerClient.scheduleNewOrchestrationInstance(clazz.getCanonicalName(), options.getNewOrchestrationInstanceOptions());
    }

    public void terminateWorkflow(String workflowInstanceId, @Nullable Object output) {
        this.innerClient.terminate(workflowInstanceId, output);
    }

    @Nullable
    public WorkflowInstanceStatus getInstanceState(String instanceId, boolean getInputsAndOutputs) {
        OrchestrationMetadata metadata = this.innerClient.getInstanceMetadata(instanceId, getInputsAndOutputs);
        if (metadata == null) {
            return null;
        }
        return new WorkflowInstanceStatus(metadata);
    }

    @Nullable
    public WorkflowInstanceStatus waitForInstanceStart(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestrationMetadata metadata = this.innerClient.waitForInstanceStart(instanceId, timeout, getInputsAndOutputs);
        return metadata == null ? null : new WorkflowInstanceStatus(metadata);
    }

    @Nullable
    public WorkflowInstanceStatus waitForInstanceCompletion(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestrationMetadata metadata = this.innerClient.waitForInstanceCompletion(instanceId, timeout, getInputsAndOutputs);
        return metadata == null ? null : new WorkflowInstanceStatus(metadata);
    }

    public void raiseEvent(String workflowInstanceId, String eventName, Object eventPayload) {
        this.innerClient.raiseEvent(workflowInstanceId, eventName, eventPayload);
    }

    public boolean purgeInstance(String workflowInstanceId) {
        PurgeResult result = this.innerClient.purgeInstance(workflowInstanceId);
        if (result != null) {
            return result.getDeletedInstanceCount() > 0;
        }
        return false;
    }

    public void createTaskHub(boolean recreateIfExists) {
        this.innerClient.createTaskHub(recreateIfExists);
    }

    public void deleteTaskHub() {
        this.innerClient.deleteTaskHub();
    }

    @Override
    public void close() throws InterruptedException {
        try {
            if (this.innerClient != null) {
                this.innerClient.close();
                this.innerClient = null;
            }
        }
        finally {
            if (this.grpcChannel != null && !this.grpcChannel.isShutdown()) {
                this.grpcChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                this.grpcChannel = null;
            }
        }
    }
}

