/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.client;

import com.microsoft.durabletask.FailureDetails;
import com.microsoft.durabletask.OrchestrationMetadata;
import io.dapr.workflows.client.WorkflowFailureDetails;
import io.dapr.workflows.runtime.WorkflowRuntimeStatus;
import java.time.Instant;
import javax.annotation.Nullable;

public class WorkflowInstanceStatus {
    private final OrchestrationMetadata orchestrationMetadata;
    @Nullable
    private final WorkflowFailureDetails failureDetails;

    public WorkflowInstanceStatus(OrchestrationMetadata orchestrationMetadata) {
        if (orchestrationMetadata == null) {
            throw new IllegalArgumentException("OrchestrationMetadata cannot be null");
        }
        this.orchestrationMetadata = orchestrationMetadata;
        FailureDetails details = orchestrationMetadata.getFailureDetails();
        this.failureDetails = details != null ? new WorkflowFailureDetails(details) : null;
    }

    public String getName() {
        return this.orchestrationMetadata.getName();
    }

    public String getInstanceId() {
        return this.orchestrationMetadata.getInstanceId();
    }

    public WorkflowRuntimeStatus getRuntimeStatus() {
        return WorkflowRuntimeStatus.fromOrchestrationRuntimeStatus(this.orchestrationMetadata.getRuntimeStatus());
    }

    public Instant getCreatedAt() {
        return this.orchestrationMetadata.getCreatedAt();
    }

    public Instant getLastUpdatedAt() {
        return this.orchestrationMetadata.getLastUpdatedAt();
    }

    public String getSerializedInput() {
        return this.orchestrationMetadata.getSerializedInput();
    }

    public String getSerializedOutput() {
        return this.orchestrationMetadata.getSerializedOutput();
    }

    @Nullable
    public WorkflowFailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    public boolean isRunning() {
        return this.orchestrationMetadata.isRunning();
    }

    public boolean isCompleted() {
        return this.orchestrationMetadata.isCompleted();
    }

    public <T> T readInputAs(Class<T> type) {
        return (T)this.orchestrationMetadata.readInputAs(type);
    }

    public <T> T readOutputAs(Class<T> type) {
        return (T)this.orchestrationMetadata.readOutputAs(type);
    }

    public String toString() {
        return this.orchestrationMetadata.toString();
    }
}

