/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import com.microsoft.durabletask.DurableTaskGrpcWorkerBuilder;
import io.dapr.utils.NetworkUtils;
import io.dapr.workflows.Workflow;
import io.dapr.workflows.internal.ApiTokenClientInterceptor;
import io.dapr.workflows.runtime.ActivityWrapper;
import io.dapr.workflows.runtime.OrchestratorWrapper;
import io.dapr.workflows.runtime.WorkflowActivity;
import io.dapr.workflows.runtime.WorkflowRuntime;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRuntimeBuilder {
    private static volatile WorkflowRuntime instance;
    private DurableTaskGrpcWorkerBuilder builder;
    private Logger logger;
    private Set<String> workflows = new HashSet<String>();
    private Set<String> activities = new HashSet<String>();
    private static ClientInterceptor WORKFLOW_INTERCEPTOR;
    private final Set<String> activitySet = Collections.synchronizedSet(new HashSet());
    private final Set<String> workflowSet = Collections.synchronizedSet(new HashSet());

    public WorkflowRuntimeBuilder() {
        this(LoggerFactory.getLogger(WorkflowRuntimeBuilder.class));
    }

    WorkflowRuntimeBuilder(Logger logger) {
        this.builder = new DurableTaskGrpcWorkerBuilder().grpcChannel((Channel)NetworkUtils.buildGrpcManagedChannel((ClientInterceptor[])new ClientInterceptor[]{WORKFLOW_INTERCEPTOR}));
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WorkflowRuntime build() {
        if (instance == null) {
            Class<WorkflowRuntime> clazz = WorkflowRuntime.class;
            // MONITORENTER : io.dapr.workflows.runtime.WorkflowRuntime.class
            if (instance == null) {
                instance = new WorkflowRuntime(this.builder.build());
            }
            // MONITOREXIT : clazz
        }
        this.logger.info("List of registered workflows: " + this.workflowSet);
        this.logger.info("List of registered activites: " + this.activitySet);
        this.logger.info("Successfully built dapr workflow runtime");
        return instance;
    }

    public <T extends Workflow> WorkflowRuntimeBuilder registerWorkflow(Class<T> clazz) {
        this.builder = this.builder.addOrchestration(new OrchestratorWrapper<T>(clazz));
        this.workflowSet.add(clazz.getCanonicalName());
        this.logger.info("Registered Workflow: " + clazz.getSimpleName());
        this.workflows.add(clazz.getSimpleName());
        return this;
    }

    public <T extends WorkflowActivity> void registerActivity(Class<T> clazz) {
        this.builder = this.builder.addActivity(new ActivityWrapper<T>(clazz));
        this.activitySet.add(clazz.getCanonicalName());
        this.logger.info("Registered Activity: " + clazz.getSimpleName());
        this.activities.add(clazz.getSimpleName());
    }

    static {
        WORKFLOW_INTERCEPTOR = new ApiTokenClientInterceptor();
    }
}

