/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.saga;

import com.microsoft.durabletask.Task;
import com.microsoft.durabletask.TaskOptions;
import com.microsoft.durabletask.interruption.ContinueAsNewInterruption;
import com.microsoft.durabletask.interruption.OrchestratorBlockedException;
import io.dapr.workflows.WorkflowContext;
import io.dapr.workflows.saga.CompensatationInformation;
import io.dapr.workflows.saga.SagaCompensationException;
import io.dapr.workflows.saga.SagaOption;
import java.util.ArrayList;
import java.util.List;

public final class Saga {
    private final SagaOption option;
    private final List<CompensatationInformation> compensationActivities = new ArrayList<CompensatationInformation>();

    public Saga(SagaOption option) {
        if (option == null) {
            throw new IllegalArgumentException("option is required and should not be null.");
        }
        this.option = option;
    }

    public void registerCompensation(String activityClassName, Object activityInput) {
        this.registerCompensation(activityClassName, activityInput, null);
    }

    public void registerCompensation(String activityClassName, Object activityInput, TaskOptions taskOptions) {
        if (activityClassName == null || activityClassName.isEmpty()) {
            throw new IllegalArgumentException("activityClassName is required and should not be null or empty.");
        }
        this.compensationActivities.add(new CompensatationInformation(activityClassName, activityInput, taskOptions));
    }

    public void compensate(WorkflowContext ctx) {
        if (this.option.isParallelCompensation() && this.compensationActivities.size() > 1) {
            this.compensateInParallel(ctx);
        } else {
            this.compensateSequentially(ctx);
        }
    }

    private void compensateInParallel(WorkflowContext ctx) {
        ArrayList tasks = new ArrayList(this.compensationActivities.size());
        for (CompensatationInformation compensationActivity : this.compensationActivities) {
            Task<Void> task = this.executeCompensateActivity(ctx, compensationActivity);
            tasks.add(task);
        }
        try {
            ctx.allOf(tasks).await();
        }
        catch (Exception e) {
            throw new SagaCompensationException("Failed to compensate in parallel.", e);
        }
    }

    private void compensateSequentially(WorkflowContext ctx) {
        Throwable sagaException = null;
        for (int i = this.compensationActivities.size() - 1; i >= 0; --i) {
            String activityClassName = this.compensationActivities.get(i).getCompensatationActivityClassName();
            try {
                this.executeCompensateActivity(ctx, this.compensationActivities.get(i)).await();
                continue;
            }
            catch (ContinueAsNewInterruption | OrchestratorBlockedException e) {
                throw e;
            }
            catch (Exception e) {
                if (sagaException == null) {
                    sagaException = new SagaCompensationException("Exception in saga compensatation: activity=" + activityClassName, e);
                } else {
                    sagaException.addSuppressed(e);
                }
                if (this.option.isContinueWithError()) continue;
                throw sagaException;
            }
        }
        if (sagaException != null) {
            throw sagaException;
        }
    }

    private Task<Void> executeCompensateActivity(WorkflowContext ctx, CompensatationInformation info) throws SagaCompensationException {
        String activityClassName = info.getCompensatationActivityClassName();
        return ctx.callActivity(activityClassName, info.getCompensatationActivityInput(), info.getTaskOptions());
    }
}

