/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.saga;

public final class SagaOption {
    private final boolean parallelCompensation;
    private final int maxParallelThread;
    private final boolean continueWithError;

    private SagaOption(boolean parallelCompensation, int maxParallelThread, boolean continueWithError) {
        this.parallelCompensation = parallelCompensation;
        this.maxParallelThread = maxParallelThread;
        this.continueWithError = continueWithError;
    }

    public boolean isParallelCompensation() {
        return this.parallelCompensation;
    }

    public boolean isContinueWithError() {
        return this.continueWithError;
    }

    public int getMaxParallelThread() {
        return this.maxParallelThread;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean parallelCompensation = false;
        private int maxParallelThread = 16;
        private boolean continueWithError = true;

        public Builder setParallelCompensation(boolean parallelCompensation) {
            this.parallelCompensation = parallelCompensation;
            return this;
        }

        public Builder setMaxParallelThread(int maxParallelThread) {
            if (maxParallelThread <= 2) {
                throw new IllegalArgumentException("maxParallelThread should be greater than 1.");
            }
            this.maxParallelThread = maxParallelThread;
            return this;
        }

        public Builder setContinueWithError(boolean continueWithError) {
            this.continueWithError = continueWithError;
            return this;
        }

        public SagaOption build() {
            return new SagaOption(this.parallelCompensation, this.maxParallelThread, this.continueWithError);
        }
    }
}

