/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class CloudEvent {
    public static final String CONTENT_TYPE = "application/cloudevents+json";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private String id;
    private String source;
    private String type;
    private String specversion;
    private String datacontenttype;
    private Object data;
    @JsonProperty(value="data_base64")
    private byte[] binaryData;

    public CloudEvent() {
    }

    public CloudEvent(String id, String source, String type, String specversion, String datacontenttype, Object data) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.specversion = specversion;
        this.datacontenttype = datacontenttype;
        this.data = data;
    }

    public CloudEvent(String id, String source, String type, String specversion, byte[] binaryData) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.specversion = specversion;
        this.datacontenttype = "application/octet-stream";
        this.binaryData = binaryData == null ? null : Arrays.copyOf(binaryData, binaryData.length);
    }

    public static CloudEvent deserialize(byte[] payload) throws IOException {
        if (payload == null) {
            return null;
        }
        return (CloudEvent)OBJECT_MAPPER.readValue(payload, CloudEvent.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public void setSpecversion(String specversion) {
        this.specversion = specversion;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public void setDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public byte[] getBinaryData() {
        return this.binaryData == null ? null : Arrays.copyOf(this.binaryData, this.binaryData.length);
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData == null ? null : Arrays.copyOf(binaryData, binaryData.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEvent that = (CloudEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.type, that.type) && Objects.equals(this.specversion, that.specversion) && Objects.equals(this.datacontenttype, that.datacontenttype) && Objects.equals(this.data, that.data) && Arrays.equals(this.binaryData, that.binaryData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.type, this.specversion, this.datacontenttype, this.data, this.binaryData);
    }
}

